C
C------------------------------------------------------
C
C     Problem:    NC_RHS
C
C     Date:       15.11.2002
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      p1, p2, p3, p4, p5, p6, p7, p8, p9, x, s, h, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t
      if (h.lt.p9) then
        u = (p5*s*p6)/((p7 + s)*(p6 + s))
      else
        if (p8.ne.p9) then
          u = p5*s*p6*(p8 - h)/((p7 + s)*(p6 + s)*(p8 - p9))
        else
          u = p5*s*p6*(p8 - h)/((p7 + s)*(p6 + s))
        endif
      endif
      x_t = (u - p1)*x
C
*     FUNCTION s_t
      s_t = -((u/p2) + p3)*x
C
*     FUNCTION h_t
      h_t = p4*u*x
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = 0.00125
C
*     FUNCTION s_0
      s_0 = 10
C
*     FUNCTION h_0
      h_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION s_fit
      s_fit = s
C
*     FUNCTION h_fit
      h_fit = h
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
c*     FUNCTION g1
c      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
