C
C------------------------------------------------------
C
C     Problem:    NA_CSTR
C
C     Date:       10.11.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      theta_co = 0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. system variables (z)
C     3. time variable (t)
C
*     VARIABLE
      Da, gamma, St, x, theta, B
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION equ_x
      equ_x = B*x - theta - St*(theta-theta_co)
C
*     FUNCTION equ_theta
      equ_theta = (theta + St*(theta-theta_co))/Da 
     /        - exp(theta/(1+theta/gamma))
     /              *(B - theta - St*(theta-theta_co))
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION x_0
      x_0 = 0
C
*     FUNCTION theta_0
      theta_0 = B
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION theta_fit
      theta_fit = theta
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

