C
C------------------------------------------------------
C
C     Problem:    MZ_FURN
C
C     Date:       2.8.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
      sigma = 5.673E-8
      l = 20
      rc = 326E4
      Ta = 300 
      W = 0.260
      Rw = 0.050
      R = 0.030 
      x1 = 0.100
      x2 = 0.224
      x3 = 0.652
      x4 = 0.776
      P1 = 860
      P2 = 1750
      P3 = 860 
C
C------------------------------------------------------
C
*     CONINT Pel1
      0.0       0.0
      26200.0   850.0
      29500.0   0.0   
C
*     CONINT Pel2
      0.0       1700.0
      3900.0    0.0   
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      lw, rcw, eps, kw, k4
      T, Tw, T_x, Tw_x, T_xx, Tw_xx
      x, time
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION T_t
      k1 = 2*eps*sigma/R
      T_t = (l*T_xx + k1*(Tw**4 - T**4))/rc
C
*     FUNCTION Tw_t
      Pel = 0
      if ((x.ge.x1).and.(x.le.x2)) then
        Pel = Pel1(time)
      else
      if ((x.gt.x2).and.(x.le.x3)) then
        Pel = Pel2(time)
      endif
      endif
      k2 = 2*pi*R/(W**2 - pi*Rw**2)*eps*sigma
      k3 = 4*W/(W**2 - pi*Rw**2)*kw
      Tw_t = (lw*Tw_xx + k2*(T**4 - Tw**4) + k3*(Ta - Tw) 
     /       + Pel)/rcw
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION T_0
      if (time.lt.1) then
        T_0 = Ta
      else
        T_0 = T
      endif    
C
*     FUNCTION Tw_0
      if (time.lt.1) then
        Tw_0 = Ta 
      else
        Tw_0 = T
      endif    
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
c*     FUNCTION u_left
c      u_left = ...
C
c*     FUNCTION u_right
c      u_right = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION T_x_left
      T_x_left = -k4*(Ta - T)/l
C
*     FUNCTION Tw_x_left
      Tw_x_left = -k4*(Ta - Tw)/lw
C
*     FUNCTION T_x_right
      T_x_right = k4*(Ta - T)/l
C
*     FUNCTION Tw_x_right
      Tw_x_right = k4*(Ta - Tw)/lw
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit1
      fit1 = T
C
*     FUNCTION fit2
      fit2 = T
C
*     FUNCTION fit3
      fit3 = T
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
