C
C------------------------------------------------------
C
C     Problem:    MYL_ESTR
C
C     Date:       27.05.2002
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, k4, k5, k6, x10, x20, x30, x40, x1, x2, x3, x4, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      w = x1 + k4*x2 + k5*x3 + k6*x4
      thetaA = x1/w
      thetaB = k4*x2/w
      thetaC = k5*x3/w
      r1 = k1*thetaA
      r2 = k2*thetaB
      r3 = k3*thetaC
      x1_t = -r1 
C
*     FUNCTION x2_t
      x2_t = r1 - r2
C
*     FUNCTION x3_t
      x3_t = r2 - r3
C
*     FUNCTION x4_t
      x4_t = r3
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = x10
C
*     FUNCTION x2_0
      x2_0 = x20
C
*     FUNCTION x3_0
      x3_0 = x30
C
*     FUNCTION x4_0
      x4_0 = x40
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C





