C
C------------------------------------------------------
C
C     Problem:    MX_ENTRO
C
C     Date:       23.11.98
C
C------------------------------------------------------
C
*     PARAMETER
      n = 9
C
C------------------------------------------------------
C
*     INDEX
      i
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Q = 1.63111E-3
      scale_k = 0.001
C
C------------------------------------------------------
C
*     SPLINE A
      0.0            1.0E-5
      3.48228E-02    4.45479E-02
      1.04468E-01    4.46462E-02
      0.174114       4.55283E-02
      0.243760       4.75957E-02
      0.313405       5.81029E-02
      0.383052       7.25574E-02
      0.524747       0.343768
      0.600713       0.433612
      0.784575       0.883097
      0.917474       0.996207
      1.0            1.0
C
C------------------------------------------------------
C
*     LININT C0
      0.0            0.0 
      3.48228E-02    1.0
      1.04468E-01    0.0
      0.174114       0.0
      0.243760       0.0
      0.313405       0.0
      0.383052       0.0
      0.524747       0.0
      0.600713       0.0
      0.784575       0.0
      0.917474       0.0
C
C------------------------------------------------------
C
*     TABLE xk(j), j in ind
      1  1.04468E-01    
      2  0.174114       
      3  0.243760       
      4  0.313405       
      5  0.383052      
      6  0.524747       
      7  0.600713       
      8  0.784575       
      9  0.917474       
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      k(j), j in ind
      C, C_x, C_xx, f, f_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux
      i = n
      ki = k(i)
      if (x.gt.xk(i)) then
        goto 200
      endif
  100 continue
      if (x.gt.xk(i-1)) then
        ki = k(i-1) + (x - xk(i-1))/(xk(i)-xk(i-1))*(k(i)-k(i-1))
        goto 200 
      endif
      i = i-1
      if (i.gt.1) then
        goto 100  
      endif
      ki = k(1)
  200 continue
      flux = ki*scale_k*A(x)*C_x
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION C_t
      C_t = (f_x - Q*C_x)/A(x)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION C_0
      C_0 = C0(x)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION C_left
      C_left = 0
C
*     FUNCTION C_right
      C_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an areas, etc.:
C
C*     FUNCTION u_x_left
C      u_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit(j), j in ind
      fit(j) = C
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


