C
C------------------------------------------------------
C
C     Problem:    MUSCLE
C
C     Date:       18.07.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      a = 4.6
      s = 1
      tau1 = 2
      tau2 = 5
      tau_r = 3
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k_on, k_off, S_total, k_ns, F, CaF, CaS, Ca_free, T, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CaF_p
      CaSp = k_on*Ca_free*(S_total - CaS) - k_off*CaS
      if (time.le.0) then
        r = 0
      else
        if (time.le.T) then
          r = s - a*exp(-time/tau1) + (a-s)*exp(-t/tau2)
        else
          r = -a*exp(-time/tau1) + (a-s)*exp(-t/tau2)
     /        + s*exp(-(time-T)*tau_r)
        endif
      endif
      Ca_freep = (r - CaSp - k_ns*Ca_free)/(1 + F)
      CaF_p = F*Ca_freep
C
*     FUNCTION CaS_p
      CaS_p = CaSp
C
*     FUNCTION Ca_free_p
      Ca_free_p = Ca_freep
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CaF_0
      if (time.lt.1) then
        CaF_0 = 0
      else
        CaF_0 = CaF
      endif
C
*     FUNCTION CaS_0
      if (time.lt.1) then
        CaS_0 = 0
      else
        CaS_0 = CaS
      endif
C
*     FUNCTION Ca_free_0
      if (time.lt.1) then
        Ca_free_0 = 0
      else
        Ca_free_0 = Ca_free
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CaF_fit
      CaF_fit = CaF
C
*     FUNCTION CaS_fit
      CaS_fit = CaS
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

