C
C------------------------------------------------------
C
C     Problem:     MULT_CST
C
C     Date:        15.12.1999
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. system variables (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, f1, f2, a1, b1, a2, b2, a3, b3, a4, b4, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION g1
      g1 = a1 + t*(k1*a1*b1 + k2*a1*(a1 - 3*b1)) - f1
C
*     FUNCTION g2
      g2 = b1 + t*k1*a1*b1 - f2
C
*     FUNCTION g3
      g3 = a2 + t*(k1*a2*b2 + k2*a2*(a2 - 3*b2)) - a1
C
*     FUNCTION g4
      g4 = b2 + t*k1*a2*b2 - b1
C
*     FUNCTION g5
      g5 = a3 + t*(k1*a3*b3 + k2*a2*(a3 - 3*b3)) - a2
C
*     FUNCTION g6
      g6 = b3 + t*k1*a3*b3 - b2
C
*     FUNCTION g7
      g7 = a4 + t*(k1*a4*b4 + k2*a4*(a4 - 3*b4)) - a3
C
*     FUNCTION g8
      g8 = b4 + t*k1*a4*b4 - b3
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION a1_0
      a1_0 = 0.1
C
*     FUNCTION b1_0
      b1_0 = 0.1
C
*     FUNCTION a2_0
      a2_0 = 0.1
C
*     FUNCTION b2_0
      b2_0 = 0.1
C
*     FUNCTION a3_0
      a3_0 = 0.1
C
*     FUNCTION b3_0
      b3_0 = 0.1
C
*     FUNCTION a4_0
      a4_0 = 0.1
C
*     FUNCTION b4_0
      b4_0 = 0.1
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION fit1
      fit1 = a4
C
*     FUNCTION fit2
      fit2 = b4
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

