C
C------------------------------------------------------
C
C     Problem:    MULTILAY
C
C     Date:       13.8.1998
C
C------------------------------------------------------
C
*     PARAMETER
      X = 6
      X1 = 2
C
C------------------------------------------------------
C
*     INDEX
      i,i1,i2,i3,i4
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind_X = 1..X
      ind_X1 = 1..X1
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Q = 286
      V = 403
      A = 2158
      S = 4.6
      Cgi = 0.124
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      kd1, kd2, aa, bb, ka0, ka1, ka2
      n0(k), k in ind_X
      n(j), j in ind_X
      Cg, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION n0_t
      n0_t = -2*ka0*Cg*n(1)**2/S + kd1*n(2)
C
*     FUNCTION n1_t
      n1_t = 2*ka0*Cg*n(1)**2/S - kd1*n(2) + kd2*n(3)
     /        - ka1*Cg*n(2)
C
*     FUNCTION n2_t
      mi = S - n(1) - n(2) - n(3)
      kd3 = aa*exp(-bb*mi)
      n2_t = -kd2*n(3) + ka1*Cg*n(2) + kd3*n(4) - ka2*Cg*n(3)
C
*     FUNCTION n_t(j), j in ind_X1
      kdi = aa*exp(-bb*mi)
      i1=j+2
      i2=j+3
      i3=j+4
      mi = mi - n(i2)
      kdi1 = aa*exp(-bb*mi)
      n_t(j) = -(kdi + ka2*Cg)*n(i2) + kdi1*n(i3) 
     /                                   + ka2*Cg*n(i1)
C
*     FUNCTION nX_t
      kdX = aa*exp(-bb*mi)
      i=X
      i1=X-1
      nX_t = -kdX*n(i) + ka2*Cg*n(i1)
C
*     FUNCTION Cg_t
      dLdt = 0.5*n1_t + 1.5*n2_t 
     /         + sum((j+2)*n_t(j),j in ind_X1) + (X-0.5)*nX_t
      Cg_t = Q/V*(Cgi - Cg) - A/V*dLdt
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION n_0(k), k in ind_X
      n_0(k) = n0(k)
C
*     FUNCTION Cg_0
      Cg_0 = 4.8
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Cg_fit
      Cg_fit = Cg
C
*     FUNCTION n_fit(j), j in ind_X
      n_fit(j) = n(j)
C
C------------------------------------------------------
C
C   - Equality constraint:
C
*     FUNCTION g
      g = (S - sum(n0(k), k in ind_X))/S
C
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

