C
C------------------------------------------------------
C
C     Problem:    MUBATCH
C
C     Date:       12.02.01
C
C------------------------------------------------------
C 
*     SET OF INDICES
      IND=1..50
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      MB0=1000   
      M0=100    
      V=10      
      R=10       
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      AA, AB, AC, AD
      XA0, XB0, XC0, XA8, XB8, XC8, DIST, MB, T 
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XA0P
      D=V/(R+1)
      L=V-D
      XD0=1-XA0-XB0-XC0
      R1=(R+1)
      XD8=1-XA8-XB8-XC8
      SUMA8=AA*XA8+AB*XB8+AC*XC8+AD*XD8
      YA8=AA*XA8/SUMA8
      YB8=AB*XB8/SUMA8
      YC8=AC*XC8/SUMA8
      YD8=1-YA8-YB8-YC8
      XA7=(R1*YA8-XA0)/R    
      XB7=(R1*YB8-XB0)/R
      XC7=(R1*YC8-XC0)/R
      XD7=1-XA7-XB7-XC7
      SUMA7=AA*XA7+AB*XB7+AC*XC7+AD*XD7
      YA7=AA*XA7/SUMA7
      YB7=AB*XB7/SUMA7
      YC7=AC*XC7/SUMA7
      YD7=1-YA7-YB7-YC7
      XA6=(R1*YA7-XA0)/R
      XB6=(R1*YB7-XB0)/R
      XC6=(R1*YC7-XC0)/R
      XD6=1-XA6-XB6-XC6
      SUMA6=AA*XA6+AB*XB6+AC*XC6+AD*XD6
      YA6=AA*XA6/SUMA6
      YB6=AB*XB6/SUMA6
      YC6=AC*XC6/SUMA6
      YD6=1-YA6-YB6-YC6
      XA5=(R1*YA6-XA0)/R
      XB5=(R1*YB6-XB0)/R
      XC5=(R1*YC6-XC0)/R
      XD5=1-XA5-XB5-XC5
      SUMA5=AA*XA5+AB*XB5+AC*XC5+AD*XD5
      YA5=AA*XA5/SUMA5
      YB5=AB*XB5/SUMA5
      YC5=AC*XC5/SUMA5
      YD5=1-YA5-YB5-YC5
      XA4=(R1*YA5-XA0)/R
      XB4=(R1*YB5-XB0)/R
      XC4=(R1*YC5-XC0)/R
      XD4=1-XA4-XB4-XC4
      SUMA4=AA*XA4+AB*XB4+AC*XC4+AD*XD4
      YA4=AA*XA4/SUMA4
      YB4=AB*XB4/SUMA4
      YC4=AC*XC4/SUMA4
      YD4=1-YA4-YB4-YC4
      XA3=(R1*YA4-XA0)/R
      XB3=(R1*YB4-XB0)/R
      XC3=(R1*YC4-XC0)/R
      XD3=1-XA3-XB3-XC3
      SUMA3=AA*XA3+AB*XB3+AC*XC3+AD*XD3
      YA3=AA*XA3/SUMA3
      YB3=AB*XB3/SUMA3
      YC3=AC*XC3/SUMA3
      YD3=1-YA3-YB3-YC3
      XA2=(R1*YA3-XA0)/R
      XB2=(R1*YB3-XB0)/R
      XC2=(R1*YC3-XC0)/R
      XD2=1-XA2-XB2-XC2
      SUMA2=AA*XA2+AB*XB2+AC*XC2+AD*XD2
      YA2=AA*XA2/SUMA2
      YB2=AB*XB2/SUMA2
      YC2=AC*XC2/SUMA2
      YD2=YA2-YB2-YC2
      XA1=(R1*YA2-XA0)/R
      XB1=(R1*YB2-XB0)/R
      XC1=(R1*YC2-XC0)/R
      XD1=1-XA1-XB1-XC1
      SUMA1=AA*XA1+AB*XB1+AC*XC1+AD*XD1
      YA1=AA*XA1/SUMA1
      YB1=AB*XB1/SUMA1
      YC1=AC*XC1/SUMA1
      YD1=YA1-YB1-YC1
      XA0P=(V*YA1-(L+D)*XA0)/M0
C
*     FUNCTION XB0P
      XB0P=(V*YB1-(L+D)*XB0)/M0
C
*     FUNCTION XC0P
      XC0P=(V*YC1-(L+D)*XC0)/M0
C
*     FUNCTION XA8P
      XA8P=(L*XA7-V*YA8)/MB
C
*     FUNCTION XB8P
      XB8P=(L*XB7-V*YB8)/MB
C
*     FUNCTION XC8P
      XC8P=(L*XC7-V*YC8)/MB
C
*     FUNCTION DISTP
      DISTP=D
C
*     FUNCTION MBP
      MBP=L-V
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION XA0_0
      XA0_0=0
C
*     FUNCTION XB0_0
      XB0_0=0
C
*     FUNCTION XC0_0
      XC0_0=0
C
*     FUNCTION XA8_0
      XA8_0=0.25
C
*     FUNCTION XB8_0
      XB8_0=0.25
C
*     FUNCTION XC8_0
      XC8_0=0.25
C
*     FUNCTION DIST_0
      DIST_0=0
C
*     FUNCTION MB_0
      MB_0=MB0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION XA0_fit
      XA0_fit=XA0
C
*     FUNCTION XB0_fit
      XB0_fit=XB0
C
*     FUNCTION XC0_fit
      XC0_fit=XC0
C
*     FUNCTION XA8_fit
      XA8_fit=XA8
C
*     FUNCTION XB8_fit
      XB8_fit=XB8
C
*     FUNCTION XC8_fit
      XC8_fit=XC8
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G =...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
