C
C------------------------------------------------------
C
C     Problem:    MOT_TSP
C
C     Date:       21.5.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      x10 = 2
      x20 = 2
C
C------------------------------------------------------
C
*     MACRO u1
      u1 = u11 + u12*t + u13*t**2 + u14*t**3 
C
*     MACRO u2
      u2 = u21 + u22*t + u23*t**2 + u24*t**3 
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      u11, u12, u13, u14
      u21, u22, u23, u24
      x40
      x1, x2, x3, x4, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = x3*cos(x4)
C
*     FUNCTION x2_t
      x2_t = x3*sin(x4)
C
*     FUNCTION x3_t
      x3_t = u1
C
*     FUNCTION x4_t
      x4_t = u2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = x10
C
*     FUNCTION x2_0
      x2_0 = x20
C
*     FUNCTION x3_0
      x3_0 = 0
C
*     FUNCTION x4_0
      x4_0 = x40
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
*     FUNCTION ctrl1
      ctrl1 = u1
C
*     FUNCTION ctrl2
      ctrl2 = u2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = x1 - 2
C
*     FUNCTION g2
      g2 = x2 - 1
C
*     FUNCTION g3
      g3 = x3 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C





