C
C------------------------------------------------------
C
C     Problem:    MOISTURE
C
C     Date:       15.1.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Twand = 60
      a = 36.22624
      b = 0.20684485
      c = 0.18539376e-5
      d = 0.23828281
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k12, ab,  y01, y02, y1, y2, y3,  T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1p
      if (y1.lt.y2) then
        y1p = 0
      else
        y1p = -k12*(y1 - y2)
      endif
C
*     FUNCTION y2p
      Tgut = a + b*t + (c*t**2)*exp(d*t)
      if (y1.lt.y2) then
        y2p = -ab*(twand - tgut)
      else
        y2p =  k12*(y1 - y2) - ab*(twand - tgut)
      endif
C
*     FUNCTION y3p
      Tgut = a + b*t + (c*t**2)*exp(d*t)
      y3p = ab*(twand - tgut)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y10
      y10 = y01
C
*     FUNCTION y20
      y20 = y02
C
*     FUNCTION y30
      y30 = 0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION FIT1
      FIT1 = y1+y2
C
*     FUNCTION FIT2
      FIT2 = y1
C
*     FUNCTION FIT3
      FIT3 = y2
C
*     FUNCTION FIT4
      FIT4 = y3
C
*     END
C
C------------------------------------------------------
C


