C
C------------------------------------------------------
C
C     Problem:    MN_CTRL
C
C     Date:       21.07.1997
C
C------------------------------------------------------
C
*     REAL CONSTANT
      r = 0.25
      c = 4.5
      K = 5
      x0 = 3
      T = 10
      N = 7
      t1 = T/N
      t2 = 2*T/N
      t3 = 3*T/N
      t4 = 4*T/N
      t5 = 5*T/N
      t6 = 6*T/N
C
C------------------------------------------------------
C
*     MACRO u
      if (time.lt.t1) then
        u = a1
      else
      if (time.lt.t2) then
        u = a2
      else
      if (time.lt.t3) then
        u = a3
      else
      if (time.lt.t4) then
        u = a4
      else
      if (time.lt.t5) then
        u = a5
      else
      if (time.lt.t6) then
        u = a6
      else
        u = a7
      endif
      endif
      endif
      endif
      endif
      endif
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a1, a2, a3, a4, a5, a6, a7, x, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t
      x_t = r*x*(1 - (1 - c*u/K)*x/K)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = x0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION u_fit
      u_fit = u
C
*     FUNCTION x_fit
      x_fit = x
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION G1
      G1 = x - 2.8
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



