C
C------------------------------------------------------
C
C     Problem:    MM_META1
C
C     Date:       14.10.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      p = 0.05
      q = 1
      Vol = 1000
      u0 = 5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, u, v, w, z, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION u_t
      u_t = -a*u/(b+u) - p*u
C
*     FUNCTION v_t
      v_t = p*Vol*u
C
*     FUNCTION w_t
      w_t = a*u/(b+u) - q*w
C
*     FUNCTION z_t
      z_t = q*Vol*v
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION u_0
      u_0 = u0
C
*     FUNCTION v_0
      v_0 = 0
C
*     FUNCTION w_0
      w_0 = 0
C
*     FUNCTION z_0
      z_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION v_fit
      v_fit = v
C
*     FUNCTION z_fit
      z_fit = z
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
