C
C------------------------------------------------------
C
C     Problem:    MMKINET
C
C     Date:       28.06.98
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1, K2, K3, S0, S, ES, P, E0, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION SP
      E=E0-ES
      SP=K2*ES-K1*E*S
C
*     FUNCTION ESP
      ESP=K1*E*S-(K3+K2)*ES
C
*     FUNCTION PP
      PP=K3*ES
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION S1
      S1=S0
C
*     FUNCTION ES1
      ES1=0
C
*     FUNCTION P1
      P1=0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION PFIT
      PFIT=P
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
