C
C------------------------------------------------------
C
C     Problem:    MIX_RAT3
C
C     Date:       11.7.1995
C
C------------------------------------------------------
C
*     REAL CONSTANT
      R = 1.987
      S = 1.0E+10
C 
C-------------------------------------------------------------
C
*     SPLINE TEMPERATURE
      0.0      291.0
      720.0    303.0
      960.0    311.0
      1200.0   316.0
      1500.0   322.0
      1800.0   331.0
      1980.0   338.0
      2160.0   346.0
      2460.0   364.0
      2640.0   365.0
      2820.0   364.0
C
C----------------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      A0, EP, M0, A, B, C, M, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION MP
      QD0=1.0E-4*(A*TEMPERATURE(T)**2 + B*TEMPERATURE(T) + C)
      MP=-A0*S*DEXP(-EP/(R*TEMPERATURE(T)))*M*QD0
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION MINIT
      MINIT=M0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION MFIT
      MFIT=M
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
