C
C------------------------------------------------------
C
C     Problem:    MIX_RAT2
C
C     Date:       29.07.1994
C
C------------------------------------------------------
C
*     REAL CONSTANT
      N=3
      R=1.987
      E=26920.0
      K0=1.572E-11
      IE=0.56779E-3
      TMEAN=330.0
C
C------------------------------------------------------
C
*     LININT TEMPERATURE
      0.0      291.0
      1200.0   316.0
      1800.0   329.0
      1980.0   333.0
      2160.0   340.0
      2280.0   350.0
      2460.0   363.0
      2640.0   367.0
      2835.0   366.0
      3000.0   364.0
      3390.0   361.0
C
C----------------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      A0, EP, M0, Y, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION YP
      KT=K0*DEXP(E/(R*TEMPERATURE(T))) 
      PT=1/(3.0*N*KT) 
      QT=-IE/(2.0*N*KT)
      RT=DSQRT(PT)
      WT=-QT/RT**3
      PHI=DLOG(WT + DSQRT(WT**2 + 1.0)) 
      QD0=2.0*RT*DSINH(PHI/3.0)
      YP=-A0*DEXP(-EP/(R*TEMPERATURE(T)) + EP/(R*TMEAN))*Y*QD0
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y0
      Y0=M0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION YFIT
      YFIT=Y
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
