C
C------------------------------------------------------
C
C     Problem:    MIXPOP
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      D=0.04
      SFEED=100  
      Y1=0.14
      Y2=0.5
      K1=10
      K2=10   
      X10=1
      X20=1
      S0=10
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      UM1, UM2, S, X1, X2, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION SP
      U1=UM1*S/(K1+S) 
      U2=UM2*X1/(K2+X1)   
      SP=D*(SFEED-S)-U1*X1/Y1
C
*     FUNCTION X1P
      X1P=U1*X1-U2*X2/Y2-D*X1 
C
*     FUNCTION X2P
      X2P=U2*X2-D*X2  
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION S_0
      S_0=S0
C
*     FUNCTION X1_0
      X1_0=X10
C
*     FUNCTION X2_0
      X2_0=X20
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION S_fit
      S_fit=S
C
*     FUNCTION X1_fit
      X1_fit=X1
C
*     FUNCTION X2_fit
      X2_fit=X2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




