C
C------------------------------------------------------
C
C     Problem:    MINWORLD
C
C     Date:       21.2.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      d = 0.01
      e = 0.02
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, c, k, x, y, z, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t
      x_t = b*x/y*z - d*x*y
C
*     FUNCTION y_t
      if (y.ge.1) then
        y_t = e*z*x - a
      else
        y_t = e*z*x - a*y
      endif
C
*     FUNCTION z_t
      z_t = c*z*y*(1 - z*y*k)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = 1
C
*     FUNCTION y_0
      y_0 = 1
C
*     FUNCTION z_0
      z_0 = 1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION y_fit
      y_fit = y
C
*     FUNCTION z_fit
      z_fit = z
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

