C
C------------------------------------------------------
C
C     Problem:    MILL3
C
C     Date:       07.11.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      T_air = 50
      T_wat = 20
      T_ini = 900
      tw1 = 4
      tw2 = 20
      Klam = 10
      K0lam = 1.5E+4 
      K0p = 7.85E+3
      Kp = -0.33
      Keps = 0.125E-6
      K1eps = 1.1
      K0eps = -0.38E-3
      C = 5.67E-8
C
C------------------------------------------------------
C
*     LININT Cp
         0.0   0.68
       780.0   1.1
       790.0   2.8
       840.0   0.72
       880.0   0.7
       920.0   0.6
      1400.0   0.73       
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      alpha_wat, alpha_air, T, T_z, T_zz, f, f_z, z, time
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux
      lambda = K0lam + Klam*T
      flux = lambda*T_z
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION T_t
      P = K0p + Kp*T
      T_t = f_z/(Cp(T)*P)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION T0
      if (time.lt.tw1) then
        T0 = T_ini
      else
        T0 = T
      endif
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION T_z_left
      lambda = K0lam + Klam*T
      if ((time.gt.tw1).and.(time.le.tw2)) then
        alpha = alpha_wat
        T_a = T_wat
      else
        alpha = alpha_air
        T_a = T_air
      endif
      eps = T*(K0eps + Keps*T) + K1eps
      T_z_left = (alpha*(T - T_a) + eps*C*((T+273.15)**4 
     /           - (T_a+273.15)**4))/lambda
C
*     FUNCTION T_z_right
      lambda = K0lam + Klam*T
      alpha = alpha_air
      T_a = T_air 
      eps = T*(K0eps + Keps*T) + K1eps
      T_z_right = -(alpha*(T - T_a) + eps*C*((T+273.15)**4 
     /            - (T_a+273.15)**4))/lambda
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit1
      fit1 = T
C
*     FUNCTION fit2
      fit2 = T
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
