C
C------------------------------------------------------
C
C     Problem:    MILL2
C
C     Date:       07.03.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      alpha_air = 60
      T_air = 50
      T_water = 20
      T_init = 900
      T_goal = 690
      V = 4.0
      time1 = 4
      time2 = 20
      time3 = 30
      thickness = 10
      Klam = 0.01
      K0lam = 15 
      K0p = 7.85
      Kp = -0.00033
      alpha_K = 1000
      C = 5.67E-8
C
C------------------------------------------------------
C
*     LININT Cp
         0.0   0.68
       780.0   1.1
       790.0   2.8
       840.0   0.72
       880.0   0.7
       920.0   0.6
      1400.0   0.73       
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      a1, a2, a3, a4, a5, T, T_z, T_zz, f, f_z, z, time
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux
      lambda = K0lam + Klam*T
      flux = lambda*T_z
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION T_t
      P = K0p + Kp*T
      T_t = f_z/(Cp(T)*P)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION T0
      if (time.lt.time1) then
        T0 = T_init
      else
        T0 = T
      endif
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION T_z_left
      lambda = K0lam + Klam*T
      if ((time.gt.time1).and.(time.le.time2)) then
        Psi = a1 + a2*thickness*V + a3*T_init + a4*T_water 
     /        + a5*T_goal
        alpha_water = alpha_K*(1 + Psi)
        alpha = alpha_water
        T_a = T_water
      else
        alpha = alpha_air
        T_a = T_air
      endif
      E = 0.001*T*(0.000125*T - 0.38) + 1.1
      T_z_left = 0.001*(alpha*(T - T_a) + E*C*((T + 273.15)**4 -
     /          (T_a + 273.15)**4))/lambda
C
*     FUNCTION T_z_right
      T_z_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit
      fit = T
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
