C
C------------------------------------------------------
C
C     Problem:    MILK2
C
C     Date:       26.10.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      H = 0.6
      gamma = 0.1
      gammap = 0.5
      f = 0.05
      beta = 1
      mue = 1/12
      Cmax = 1E4
      lambda = 2
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      phi, delta, kappa, eps, B, M, Mstar, C, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION B_t
      B_t = H - B*gamma - B*gammap*C/(C + phi)
C
*     FUNCTION M_t
      M_t = f*B*gamma + B*gammap*C/(C + phi) - M*mue
     /       - M*C*delta 
C
*     FUNCTION Mstar_t
      Mstar_t = M*C*delta - Mstar*eps 
C
*     FUNCTION C_t
      C_t = beta*C*(1-(C/Cmax)) - M*C*kappa - lambda*Mstar 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION B_0
      B_0 = 6
C
*     FUNCTION M_0
      M_0 = 0.36
C
*     FUNCTION Mstar_0
      Mstar_0 = 0
C
*     FUNCTION C_0
      C_0 = 0.0005
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION B_fit
      B_fit = B
C
*     FUNCTION PMN_fit
      PMN_fit = M + Mstar
C
*     FUNCTION C_fit
      C_fit = C
C
*     FUNCTION M_fit
      M_fit = M
C
*     FUNCTION Mstar_fit
      Mstar_fit = Mstar
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
