C
C------------------------------------------------------
C
C     Problem:    MICGROWY
C
C     Date:       15.05.2002
C
C------------------------------------------------------
C                    
*     PARAMETER
      ng = 20
      n = 19     
      n1 = 18 
      n2 = 17
C
C------------------------------------------------------
C                    
*     INDEX
      i      
C
C------------------------------------------------------
C      
*     SET OF INDICES
      indg = 1..ng
      ind = 1..n            
      ind1 = 1..n1
      ind2 = 1..n2
C
C------------------------------------------------------
C                                        
*     REAL CONSTANT
      m = 0.29    
      CSin = 500   
      YXS = 0.47
      Vstar = 7
      mue_m = 2.1   
C
C------------------------------------------------------
C
*     TABLE time(k), k in ind1
      1  10.0  
      2  20.0  
      3  30.0  
      4  40.0  
      5  50.0
      6  60.0
      7  62.0
      8  64.0
      9  66.0
      10 68.0
      11 70.0
      12 72.0
      13 74.0
      14 76.0
      15 78.0
      15 80.0
      16 82.0
      17 84.0
      18 86.0
C
C------------------------------------------------------
C
*     MACRO Fin
      if (t.le.time(1)) then
        Fin = Fin_c(1)
        goto 1000
      endif          
      i = n1
      if (t.ge.time(i)) then
        Fin = Fin_c(i)
        goto 1000
      endif  
      i = 1
 1100 continue      
      if ((t.ge.time(i)).and.(t.lt.time(i+1))) then
        Fin = Fin_c(i) 
     /          + (t - time(i))/(time(i+1)-time(i))*(Fin_c(i+1)-Fin_c(i)) 
        goto 1000
      endif
      i = i+1
      if (i.lt.n) then
        goto 1100
      endif       
 1000 continue     
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Kp, Ki
      Fin_c(k), k in ind  
      CS0, CX0
      CS, CX, V, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CS_t
      mue = mue_m*CS/(Kp + CS + CS**2/Ki)
      sigma = mue/YXS + m
      CS_t = -sigma*CX + Fin*(CSin - CS)/V
C
*     FUNCTION CX_t
      CX_t = mue*CX - Fin*CX/V
C
*     FUNCTION V_t
      V_t = Fin
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CS_0  
      if (t.lt.1) then
        CS_0 = CS0
      else
        CS_0 = CS
      endif    
C
*     FUNCTION CX_0
      if (t.lt.1) then
        V0 = Vstar*CSin/(CSin - CS0)
        CX_0 = CX0/V0
      else
        cX_0 = CX
      endif    
C
*     FUNCTION V_0
      if (t.lt.1) then
        V_0 = V0
      else
        V_0 = V
      endif    
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CS_fit   
      if (CS.gt.0) then
        CS_fit = CS
      else
        CS_fit = 0
      endif    
C
*     FUNCTION CX_fit
      CX_fit = CX
C
*     FUNCTION V_fit
      V_fit = V
C
*     FUNCTION ctrl
      ctrl = Fin
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g(k), k in indg
      g(k) = CS 
C    
*     FUNCTION mono(k), k in ind2
      mono(k) = Fin_c(k+1) - Fin_c(k)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

