C
C------------------------------------------------------
C
C     Problem:    MICGROWX
C
C     Date:       15.05.2002
C
C------------------------------------------------------
C                               
*     SET OF INDICES
      ind = 1..8
C
C------------------------------------------------------
C                                        
*     REAL CONSTANT
      m = 0.29    
      CSin = 500   
      YXS = 0.47
      Vstar = 7
      mue_m = 2.1
C
C------------------------------------------------------
C
*     LININT Fin
      0.0    0.0
      50.0   0.0
      60.0   0.01
      62.0   0.03
      64.0   0.05
      66.0   0.07
      68.0   0.09
      70.0   0.11
      72.0   0.13
      74.0   0.15
      76.0   0.17
      78.0   0.19
      80.0   0.21
      82.0   0.23
      84.0   0.25
      86.3   0.26
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Kp, Ki, CS0, CX0
      CS, CX, V, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CS_t
      CS1 = CS                       
      if (CS.lt.0) then
        CS1 = 0
      endif  
      mue = mue_m*CS1/(Kp + CS1 + CS1**2/Ki)
      sigma = mue/YXS + m
      CS_t = -sigma*CX + Fin(t)*(CSin - CS1)/V
C
*     FUNCTION CX_t
      CX_t = mue*CX - Fin(t)*CX/V
C
*     FUNCTION V_t
      V_t = Fin(t)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CS_0  
      if (t.lt.1) then
        CS_0 = CS0
      else
        cS_0 = CS
      endif    
C
*     FUNCTION CX_0
      if (t.lt.1) then
        V0 = Vstar*CSin/(CSin - CS0)
        CX_0 = CX0/V0
      else
        cX_0 = CX
      endif    
C
*     FUNCTION V_0
      if (t.lt.1) then
        V_0 = V0
      else
        V_0 = V
      endif    
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CS_fit
      CS_fit = CS
C
*     FUNCTION CX_fit
      CX_fit = CX
C
*     FUNCTION V_fit
      V_fit = V
C
*     FUNCTION ctrl
      ctrl = Fin(t)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g(k), k in ind
      g(k) = CS 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

