C
C------------------------------------------------------
C
C     Problem:    MET_SURF
C  
C     Date:       05.08.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      A = 2158
      V = 403
      Q = 286
      X = 460
      CAi = 0.0867
      CBi = 0.0867
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1, K2, K3, K4, K_4, K5, CA, CB, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CA_t
      IF (CA.GE.0) THEN
        SQ = SQRT(K1*CA)
      ELSE
        SQ = 1.0E-10
      ENDIF
      TERM = K4*K3*CB*X*SQ
     /        /(1 + SQ + K2*CB + K3*CB*SQ + CB/(K5*SQ))
     /                                   - K_4*CA*CB*X
     /        /(K5*SQ*(1 + SQ + K2*CB + K3*CB*SQ
     /                                   + CB/(K5*SQ)))
      CA_t = Q/V*(CAi - CA) - A/V*TERM
C
*     FUNCTION CB_t
      CB_t = Q/V*(CBi - CB) - A/V*TERM
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CA_0
      CA_0 = 3.38
C
*     FUNCTION CB_0
      CB_0 = 4.30
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CA_fit
      CA_fit = CA
C
*     FUNCTION CB_fit
      CB_fit = CB
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



