C
C------------------------------------------------------
C
C     Problem:    METHYL
C
C     Date:       9.11.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      theta_a = 0
      B = 100
      n = 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      gamma, psi, x, theta, tau
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_tau
      if (x.gt.0) then 
        xn = x**n
      else
        xn = 0
      endif
      k = exp(theta/(1 + theta/gamma))*(1 - xn)
      x_tau = k
C
*     FUNCTION theta_tau
      theta_tau = B*(k - (theta - theta_a)/psi)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = 0
C
*     FUNCTION theta_0
      theta_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION theta_fit
      theta_fit = theta
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

