C
C------------------------------------------------------
C
C     Problem:     METHANE
C
C     Date:        30.05.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT 
      a0 = 3.846E-5
      a1 = 3.846
      c2 = 3.34E-03
      c4 = 1.93E-01
      c5 = 1.8
      c6 = 2.15E-04
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. system variables (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      c1, c3, x1, x2, c
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION f1
      x11 = x1/a0
      if (x11.lt.0) then
        x11 = 1e-10
      endif
      x10 = 3 - x2
      if (x10.lt.0) then
        x10 = 1e-10
      endif
      if (x2.gt.0) then
        x6 = c1*sqrt(x2*x11)
      else
        x6 = 0
      endif
      x7 = c2*sqrt(x10*x11)
      x4 = (c3 - 0.5*(x6 + x7))/(1 + c4*x2/x10)
      x5 = c4*x2*x4/x10
      x12 = c
      x3 = 2*x12 - 0.5*x5
      if (x3.lt.0) then
        x3 = 1e-10
      endif
      x8 = c5*x4*x1/(a1*x2)
      x9 = c6*x10*sqrt(x3*x11)/x2
      f1 = 2*(x1 + x10) + x2 + x4 + x7 + x8 + x9 - x12
C
*     FUNCTION f2
      f2 = x1 + x2 + x3 + x4 + x5 + x6 + x7 + x8 + x9 + x10 - x11
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION x1_0
      x1_0 = 0.1
C
*     FUNCTION x2_0
      x2_0 = 0.1
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C







