C
C------------------------------------------------------
C
C     Problem:    METHAN
C
C     Date:       09.09.98
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, k4, k5, D, y1, y2, y3, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      q = (k2 + k5)*y1 + y2
      y1_t = -(2*k1 - k1*y2/q + k3 + k4)*y1
C
*     FUNCTION y2_t
      y2_t = k1*y1*(k2*y1 - y2)/q + k3*y1
C
*     FUNCTION y3_t
      y3_t = k1*y1*(y2 + k5*y1)/q + k4*y1
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = D
C
*     FUNCTION y2_0
      y2_0 = 0
C
*     FUNCTION y3_0
      y3_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y3_fit
      y3_fit = y3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
