C
C------------------------------------------------------
C
C     Problem:    MEM_WIRE
C
C     Date:       03.12.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      extemp = 0.1
C
C------------------------------------------------------
C
*     CONINT joule
      0.0 0.0     
      2.0 0.1
      3.0 0.0
      6.0 0.1
      7.0 0.0 
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      muell, lambda, alfa, taux, grengi
      xpls, xmns, temp, disp, c, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION xpls_p
      muerr = -muell
      last = 1 - disp 
      a1 = 1/(muerr-1)**2
      a3 = (1-lambda)/muerr**2
      kappa = a3/a1
      xaus = 1 - xpls - xmns
      xm = xpls + xmns
      egrenz = EXP(grengi/temp*(1.0 - 2.0*xm))
      xpls_p = -xpls/sqrt(kappa)/taux*
     $         EXP(-(last**2/4.0*(muerr-1.0)**2 + last)/temp)*
     $         EXP(-(1.0-muerr*last)/temp)*egrenz + xaus/taux*
     $         EXP(-(last**2/4.0/kappa*(muell+1.0)**2 -
     $         (1.0-kappa*muerr**2/(muerr-1.0)**2))/temp)*
     $         EXP(-(1.0-muerr*last)/temp)/egrenz
C
*     FUNCTION xmns_p
      muerr = -muell
      last = 1 - disp 
      a1 = 1/(muerr-1)**2
      a3 = (1-lambda)/muerr**2
      kappa = a3/a1
      xaus = 1 - xpls - xmns
      xm = xpls + xmns
      egrenz = EXP(grengi/temp*(1.0 - 2.0*xm))
      xmns_p = -xmns/sqrt(kappa)/taux*
     $         EXP(-(last**2/4.0*(muell+1.0)**2-last)/temp)*
     $         EXP(-(1.0-muell*last)/temp)*egrenz+xaus/taux*
     $         EXP(-(last**2/4.0/kappa*(muell+1.0)**2 -
     $         (1.0-kappa*muerr**2/(muerr-1.0)**2))/temp)*
     $         EXP(-(1.0-muell*last)/temp)/egrenz
C
*     FUNCTION temp_p
      temp_p = -1.0/alfa*(temp - extemp) + c*joule(t)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION disp_alg
      muerr = -muell
      last = 1 - disp 
      a1 = 1/(muerr-1)**2
      a3 = (1-lambda)/muerr**2
      kappa = a3/a1
      xaus = 1 - xpls - xmns
      disp_alg = last*(muerr - 1.0)**2/2.0/kappa*
     /          (kappa*(xpls+xmns)+xaus)+(xpls-xmns) 
     /          - disp
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION xpls_0
      IF (t.LT.1) THEN
        xpls_0 = 1.0
      ELSE
        xpls_0 = xpls
      ENDIF
C
*     FUNCTION xmns_0
      IF (t.LT.1) THEN
        xmns_0 = 0.0
      ELSE
        xmns_0 = xmns
      ENDIF
C
*     FUNCTION temp_0
      temp_0 = 0.1
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION disp_0
      disp_0 = 1.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION disp_fit
      disp_fit = disp
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
c*     FUNCTION G1
c      G1 = disp - 0.84
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



