C
C------------------------------------------------------
C
C     Problem:    MEM_SEP
C
C     Date:       9.4.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Kd = 1.4E-8
      v = 5.3E-4
      s_D = 1.0E-7
      c0 = 1.4E-5
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first space derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second space derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. space variable (x)
C     7. time variable (t)
C
*     VARIABLE
      ka, D, c1
      cs, c, cs_z, c_z, cs_zz, c_zz
      z, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION cs_t
      cs_t = ka*(c*(c1 - cs) - Kd*cs)
C
*     FUNCTION c_t
      c_t = D*s_D*c_zz - v*c_z - 0.4*cs_t
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION cs_0
      cs_0 = 0.0
C
*     FUNCTION c_0
      c_0 = 0.0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
C*     FUNCTION VP
C      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
C*     FUNCTION V0
C      V0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
c*     FUNCTION UT
c      UT = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. space 
C     variable first at left borders of all areas, then 
C     at right borders of all areas:
C
*     FUNCTION cl_z
      cl_z = v*(c - c0)/(D*s_D)
C
*     FUNCTION cr_z
      cr_z = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit(i), i in ind
      fit(i) = cs/c0
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


