C
C------------------------------------------------------
C
C     Problem:    MEMSEP
C
C     Date:       12.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      Nf=50            
      d=3.81E-5      
      A1=5          
      A2=5    
      V1=0.01  
      V2=0.01
      V3=0.01      
      P1=26E5       
      P2=5.6E5    
      P3=1E5      
      R=8.314e3     
      Temp=298      
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      kpOs, kpNs, CO1S, CN1, CO2S, CN2, CO3S, CN3, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CO1P
      Gf = Nf*R*Temp/P1/1000  
      kpO=kpOs*1E-12
      kpN=kpNs*1E-12
      CO1=CO1S
      IF (CO1.LT.0) THEN
        CO1=0 
      ENDIF
      CO2=CO2S
      IF (CO2.LT.0) THEN
        CO2=0 
      ENDIF
      CO3=CO3S
      IF (CO3.LT.0) THEN
        CO3=0
      ENDIF 
      XO1=CO1/(CO1+CN1)   
      XO2=CO2/(CO2+CN2)   
      XO3=CO3/(CO3+CN3)   
      XN1=1-XO1   
      XN2=1-XO2   
      XN3=1-XO3   
      COf=P1*XO1/(R*Temp) 
      CNf=P1*XN1/(R*Temp) 
      RO1=(kpO/d)*(P1*XO1-P2*XO2)*A1  
      RN1=(kpN/d)*(P1*XN1-P2*XN2)*A1  
      RO2=(kpO/d)*(P2*XO2-P3*XO3)*A2  
      RN2=(kpN/d)*(P2*XN2-P3*XN3)*A2  
      G1=Gf-(RO1+RN1)*(R*Temp/P1) 
      G2=(RO1+RN1-RO2-RN2)*(R*Temp/P2)
      G3=(RO2+RN2)*(R*Temp/P3)
      IF (G1.LT.0) THEN
        G1=0   
      ENDIF
      IF (G2.LT.0) THEN
        G2=0   
      ENDIF
      IF (G3.LT.0) THEN
        G3=0
      ENDIF   
      CO1P=(Gf*COf-G1*CO1-RO1)/V1 
C
*     FUNCTION CN1P
      CN1P=(Gf*CNf-G1*CN1-RN1)/V1 
C
*     FUNCTION CO2P
      CO2P=(RO1-RO2-G2*CO2)/V2
C
*     FUNCTION CN2P
      CN2P=(RN1-RN2-G2*CN2)/V2
C
*     FUNCTION CO3P
      CO3P=(RO2-G3*CO3)/V3
C
*     FUNCTION CN3P
      CN3P=(RN2-G3*CN3)/V3
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CO1_0
      XO1=0.209   
      COf=P1*XO1/(R*Temp) 
      CO1_0=COf
C
*     FUNCTION CN1_0
      XN1=0.791   
      CNf=P1*XN1/(R*Temp) 
      CN1_0=CNf
C
*     FUNCTION CO2_0
      XO2=0.209   
      CO2_0=P2*XO2/(R*Temp) 
C
*     FUNCTION CN2_0
      XN2=0.791   
      CN2_0=P2*XN2/(R*Temp) 
C
*     FUNCTION CO3_0
      XO3=0.209   
      CO3_0=P3*XO3/(R*Temp) 
C
*     FUNCTION CN3_0
      XN3=0.791   
      CN3_0=P3*XN3/(R*Temp) 
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CO1_fit
      CO1_fit=CO1
C
*     FUNCTION CN1_fit
      CN1_fit=CN1
C
*     FUNCTION CO2_fit
      CO2_fit=CO2
C
*     FUNCTION CN2_fit
      CN2_fit=CN2
C
*     FUNCTION CO3_fit
      CO3_fit=CO3
C
*     FUNCTION CN3_fit
      CN3_fit=CN3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
