C
C------------------------------------------------------
C
C     Problem:    MEMINH
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      F=2
      V=10
      S0=10   
      CLS=10
      UM=1.5
      KI=5
      K0=0.5 
      MS=0.1
      MO=0.3 
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      KS, YSX, Y0X, X, S, CL, KLA, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XP
      U=UM*(S/(KS+S+(S*S/KI)))*(CL/(CL+K0))   
      RX=U*X       
      RS=RX*YSX+MS*X  
      RO=RX*Y0X+MO*X  
      XP=RX                 
C
*     FUNCTION SP
      SP=(F/V)*(S0-S)-RS  
C
*     FUNCTION CLP
      CLP=KLA*(CLS-CL)-RO 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      X_0=1.5
C
*     FUNCTION S_0
      S_0=0
C
*     FUNCTION CL_0
      CL_0=10
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X_fit
      X_fit=X
C
*     FUNCTION S_fit
      S_fit=S
C
*     FUNCTION CL_fit
      CL_fit=CL
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
