C
C------------------------------------------------------
C
C     Problem:    MEMBRANE
C
C     Date:       14.05.2002
C
C------------------------------------------------------
C
*     LININT activator
      0.0    0.0
      0.15   0.0
      0.1501 45.0
      0.6    30.0
      0.8    25.0
      0.9    20.0
      1.0    2.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      a, c1l, c2r, c1, c2, c1_x, c2_x, c1_xx, c2_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION c1_t
      c1_t = c1_xx - a*c2/(1 + c2)*c1/(1 + c1)
C
*     FUNCTION c2_t
      c2_t = c2_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION c1_0
      if (t.lt.0.0001) then
        c1_0 = 0
      else
        c1_0 = c1
      endif
C
*     FUNCTION c2_0
      if (t.lt.0.0001) then
        c2_0 = 0
      else
        c2_0 = c2
      endif
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION c1_left
      c1_left = c1l
C
*     FUNCTION c2_left
      c2_left = activator(t)
C
*     FUNCTION c1_right
      c1_right = activator(t)
C
*     FUNCTION c2_right
      c2_right = c2r
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
C*     FUNCTION u_x_left
C      u_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit1
      fit1 = c1
C
*     FUNCTION fit2
      fit2 = c2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

