C
C
C------------------------------------------------------
C
C     Problem:    MECH_SYS
C
C     Date:       5.10.1996
C
C------------------------------------------------------
C
*     PARAMETER
      ii = 17
      jj = 10
C
C------------------------------------------------------
C
*     SET OF INDICES
      harmi = 1..ii
      harmj = 1..jj
C
C------------------------------------------------------
C
*     REAL CONSTANTS
      M=25.4
      L=0.35
      PI=ACOS(-1)
      DREH=175.0
      PER=60.0/DREH
      P=2.0*PI/PER
      BOG=PI/180.0
      VAM=DREH/88.0
      WBMIT= 3.219515E-002
      GBMIT= 4.191512E-006
C
C------------------------------------------------------
C
*     TABLE WB(i), i IN harmi
       1     3.919838E-002
       2     5.179583E-003
       3     2.226558E-003
       4     3.557963E-004
       5     1.102032E-004
       6     1.980949E-005
       7     6.449622E-006
       8     1.338107E-006
       9     8.169716E-007
      10     4.876920E-007
      11     7.447937E-008
      12     1.895697E-007
      13     1.845634E-007
      14     2.658099E-007
      15     3.704487E-007
      16     1.884264E-007
      17     3.809286E-008
C
*     TABLE WP(i), i IN harmi
       1    -1.623779E+002
       2     5.209486E+001
       3     4.130599E+001
       4    -2.613233E+001
       5    -8.093697E+001
       6    -1.547569E+002
       7     1.373598E+002
       8     5.623559E+001
       9    -2.203839E+001
      10     1.108576E+002
      11    -1.771229E+002
      12    -5.370192E+001
      13     2.102015E+001
      14     1.514898E+000
      15     1.724337E+002
      16    -1.293816E+002
      17     8.914515E+001
C  
*     TABLE GB(i), i IN harmi
       1    3.608833E-001
       2    9.537686E-002
       3    6.150769E-002
       4    1.310140E-002
       5    5.065960E-003
       6    1.091684E-003
       7    3.928867E-004
       8    1.043311E-004
       9    4.145422E-005
      10    1.765435E-005
      11    5.521548E-006
      12    6.340877E-006
      13    6.728598E-006
      14    5.852177E-006
      15    1.109371E-005
      16    4.145777E-006
      17    2.256886E-006
C     
*     TABLE GP(i), i IN harmi
       1    -7.237407E+001
       2     1.420898E+002
       3     1.313082E+002
       4     6.368810E+001
       5     9.045156E+000
       6    -6.451551E+001
       7    -1.322295E+002
       8     1.451578E+002
       9     7.908413E+001
      10     4.214256E+000
      11     5.949893E+001
      12     3.729472E+001
      13     8.401183E+001
      14     8.856477E+001
      15     6.189272E+001
      16     2.503478E+001
      17     1.144205E+002
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      TH, THP, FQ0, FQ1, FQ2, SPIEL, Y1, Y2, Y3, Y4, TT
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      Y1P=Y2
C
*     FUNCTION Y2P
      WEG =WBMIT+SUM(WB(i)*COS((i)*P*TT
     /          +WP(i)*BOG), i IN harmj)
      GES = VAM*GBMIT+SUM(VAM*GB(i)*COS((i)*P*TT
     /          +GP(i)*BOG), i IN harmj)
      LAM1=(FQ1/FQ0)**2
      LAM2=(FQ2/FQ0)**2
      AAA =-LAM1*LAM2/((LAM1-1)*(LAM2-1))
      BBB =(-1)/((LAM1-1)*(LAM2-1))
      MY1  =M*(1+(LAM1-1)**2*BBB)
      MY2  =M*(1+(LAM2-1)**2*BBB)
      C   =(2*PI*FQ0)**2*M
      CT  =AAA*C*L**2
      J   =BBB*M*L**2
      OM0=2*PI*FQ0
      OM1=2*PI*FQ1
      OM2=2*PI*FQ2
      OM0Q=OM0**2
      LAM1Q=LAM1**2
      k=FQ2/FQ1
      BT=-2*L**2*(k**4*MY1
     /  *OM1*TH-MY2*OM2*THP)/(k**4*(2*LAM1-1)-2*k**2*LAM1+1)
      B=2*(k**4*LAM1Q*MY1*OM1*TH-2*k**2*LAM1*MY1*OM1*TH
     / -LAM1Q*MY2*OM2*THP+2*LAM1*MY2*OM2*THP
     / +MY1*OM1*TH-MY2*OM2*THP)/(LAM1Q*(k**4*(2*LAM1-1)
     / -2*k**2*LAM1+1))
      Y2P=-OM0Q*(Y1+Y3)-B/M*(Y2+Y4)+OM0Q*WEG+B/M*GES
C
*     FUNCTION Y3P
      Y3P=Y4
C
*     FUNCTION Y4P
      IF (Y3.gt.SPIEL/2) THEN
       Y4P=1/BBB*(-OM0Q*(Y1+Y3)-B/M*(Y2+Y4)-AAA*OM0Q
     /    *(Y3-SPIEL/2)-BT/(M*L**2)*Y4
     /    +OM0Q*WEG+B/M*GES)
      ELSE
      IF (Y3.lt.-SPIEL/2) THEN
       Y4P=1/BBB*(-OM0Q*(Y1+Y3)-B/M*(Y2+Y4)-AAA*OM0Q
     /    *(Y3+SPIEL/2)-BT/(M*L**2)*Y4
     /    +OM0Q*WEG+B/M*GES)
       ELSE
        Y4P=1/BBB*(-OM0Q*(Y1+Y3)-B/M*(Y2+Y4)
     /     +OM0Q*WEG+B/M*GES)
       ENDIF
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      Y10=WBMIT+SUM(WB(i)*COS((i)*P*0.0
     /       +WP(i)*BOG), i IN harmj)
C
*     FUNCTION Y20
      Y20=(VAM*GBMIT+SUM(VAM*GB(i)*COS((i)*P*0.0
     /       +GP(i)*BOG), i IN harmj))
C 
*     FUNCTION Y30
      Y30= WBMIT+(SUM(WB(i)*COS((i)*P*0.0
     /       +WP(i)*BOG), i IN harmj))
C     
*     FUNCTION y40
      Y40= (VAM*GBMIT+SUM(VAM*GB(i)*COS((i)*P*0.0
     /       +GP(i)*BOG), i IN harmj))
C
C------------------------------------------------------
C
C   - Fitting functions:
C
*     FUNCTION LFIT
      LAM1=(FQ1/FQ0)**2
      LAM2=(FQ2/FQ1)**2*LAM1
      AAA =-LAM1*LAM2/((LAM1-1)*(LAM2-1))
      BBB =(-1)/((LAM1-1)*(LAM2-1))
      MY1  =M*(1+(LAM1-1)**2*BBB)
      MY2  =M*(1+(LAM2-1)**2*BBB)
      C   =(2*PI*FQ0)**2*M
      CT  =AAA*C*L**2
      J   =BBB*M*L**2
      OM0=2*PI*FQ0
      OM1=2*PI*FQ1
      OM2=2*PI*FQ2
      OM0Q=OM0**2
      LAM1Q=LAM1**2
      k=FQ2/FQ1
      B=2*(k**4*LAM1Q*MY1*OM1*TH-2*k**2*LAM1*MY1*OM1*TH
     / -LAM1Q*MY2*OM2*THP+2*LAM1*MY2*OM2*THP
     / +MY1*OM1*TH-MY2*OM2*THP)/(LAM1Q*(k**4*(2*LAM1-1)
     / -2*k**2*LAM1+1))
      BT=-2*L**2*(k**4*MY1
     /  *OM1*TH-MY2*OM2*THP)/(k**4*(2*LAM1-1)-2*k**2*LAM1+1)
      WEG = WBMIT+SUM(WB(i)*COS((i)*P*TT
     /          +WP(i)*BOG), i IN harmj)
      GES = VAM*GBMIT+SUM(VAM*GB(i)*COS((i)*P*TT
     /          +GP(i)*BOG), i IN harmj)
      IF (Y3.gt.SPIEL/2) THEN
       Y2P=-OM0Q*(Y1+Y3)-B/M*(Y2+Y4)+OM0Q*WEG+B/M*GES
       Y4P=1/BBB*(-OM0Q*(Y1+Y3)-B/M*(Y2+Y4)-AAA*OM0Q
     /    *(Y3-SPIEL/2)-BT/(M*L**2)*Y4
     /    +OM0Q*WEG+B/M*GES)
       LFIT=Y2P-Y4P
       ELSE
       IF (Y3.lt.-SPIEL/2) THEN
        Y2P=-OM0Q*(Y1+Y3)-B/M*(Y2+Y4)+OM0Q*WEG+B/M*GES
        Y4P=1/BBB*(-OM0Q*(Y1+Y3)-B/M*(Y2+Y4)-AAA*OM0Q
     /     *(Y3+SPIEL/2)-BT/(M*L**2)*Y4
     /     +OM0Q*WEG+B/M*GES)
        LFIT=Y2P-Y4P
        ELSE
        Y2P=-OM0Q*(Y1+Y3)-B/M*(Y2+Y4)+OM0Q*WEG+B/M*GES
        Y4P=1/BBB*(-OM0Q*(Y1+Y3)-B/M*(Y2+Y4)
     /     +OM0Q*WEG+B/M*GES)
        LFIT=Y2P-Y4P
       ENDIF
      ENDIF
C
*     FUNCTION RFIT
      LAM1=(FQ1/FQ0)**2
      LAM2=(FQ2/FQ1)**2*LAM1
      AAA =-LAM1*LAM2/((LAM1-1)*(LAM2-1))
      BBB =(-1)/((LAM1-1)*(LAM2-1))
      MY1  =M*(1+(LAM1-1)**2*BBB)
      MY2  =M*(1+(LAM2-1)**2*BBB)
      C   =(2*PI*FQ0)**2*M
      CT  =AAA*C*L**2
      J   =BBB*M*L**2
      OM0=2*PI*FQ0
      OM1=2*PI*FQ1
      OM2=2*PI*FQ2
      OM0Q=OM0**2
      LAM1Q=LAM1**2
      k=FQ2/FQ1
      B=2*(k**4*LAM1Q*MY1*OM1*TH-2*k**2*LAM1*MY1*OM1*TH
     / -LAM1Q*MY2*OM2*THP+2*LAM1*MY2*OM2*THP
     / +MY1*OM1*TH-MY2*OM2*THP)/(LAM1Q*(k**4*(2*LAM1-1)
     / -2*k**2*LAM1+1))
      BT=-2*L**2*(k**4*MY1
     /  *OM1*TH-MY2*OM2*THP)/(k**4*(2*LAM1-1)-2*k**2*LAM1+1)
      WEG = WBMIT+SUM(WB(i)*COS((i)*P*TT
     /          +WP(i)*BOG), i IN harmj)
      GES = VAM*GBMIT+SUM(VAM*GB(i)*COS((i)*P*TT
     /          +GP(i)*BOG), i IN harmj)
      IF (Y3.gt.SPIEL/2) THEN
       Y2P=-OM0Q*(Y1+Y3)-B/M*(Y2+Y4)+OM0Q*WEG+B/M*GES
       Y4P=1/BBB*(-OM0Q*(Y1+Y3)-B/M*(Y2+Y4)-AAA*OM0Q
     /    *(Y3-SPIEL/2)-BT/(M*L**2)*Y4
     /    +OM0Q*WEG+B/M*GES)
       RFIT=Y2P+Y4P
       ELSE
       IF (Y3.lt.-SPIEL/2) THEN
        Y2P=-OM0Q*(Y1+Y3)-B/M*(Y2+Y4)+OM0Q*WEG+B/M*GES
        Y4P=1/BBB*(-OM0Q*(Y1+Y3)-B/M*(Y2+Y4)-AAA*OM0Q
     /     *(Y3+SPIEL/2)-BT/(M*L**2)*Y4
     /     +OM0Q*WEG+B/M*GES)
        RFIT=Y2P+Y4P
        ELSE
        Y2P=-OM0Q*(Y1+Y3)-B/M*(Y2+Y4)+OM0Q*WEG+B/M*GES
        Y4P=1/BBB*(-OM0Q*(Y1+Y3)-B/M*(Y2+Y4)
     /     +OM0Q*WEG+B/M*GES)
        RFIT=Y2P+Y4P
       ENDIF
      ENDIF
C
C---------------------------------------------------------------------
C
*     END
C
C---------------------------------------------------------------------
C
