C
C------------------------------------------------------
C
C     Problem:    MC_DIST
C
C     Date:       18.12.97
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..10
C
C------------------------------------------------------
C
*     REAL CONSTANT
      L = 15.6
      V = 17.6
      F = 5.0
      x1f = 0.13
      x2f = 0.72
      Hc = 2.75
      Hb = 13.5
      hL = 1.35
      psi = 50.0
      lr = 6.0
      ls = 4.0
      init = 0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      xr10, xr20, xc30, xc40
      x1, x2, x3, x4
      x1_z, x2_z, x3_z, x4_z
      x1_zz, x2_zz, x3_zz, x4_zz
      xb1, xb2, xc1, xc2
      z, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION FLUX
C      FLUX = U
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION xs1_t
      f1 = 1.18*x1/(0.18*x1 + 0.58*x2 + 0.42)
      xs1_t = ((L+F)*x1_z + psi*(x3 - f1))/hL
C
*     FUNCTION xs2_t
      f2 = x2/(0.18*x1 + 0.58*x2 + 0.42)
      xs2_t = ((L+F)*x2_z + psi*(x4 - f2))/hL
C
*     FUNCTION ae_s1
      ae_s1 = V*x3_z + psi*(x3 - f1)
C
*     FUNCTION ae_s2
      ae_s2 = V*x4_z + psi*(x4 - f2)
C
*     FUNCTION xr1_t
      f1 = 1.18*x1/(0.18*x1 + 0.58*x2 + 0.42)
      xr1_t = (L*x1_z + psi*(x3 - f1))/hL
C
*     FUNCTION xr2_t
      f2 = x2/(0.18*x2 + 0.58*x2 + 0.42)
      xr2_t = (L*x2_z + psi*(x4 - f2))/hL
C
*     FUNCTION ae_r1
      ae_r1 = V*x3_z + psi*(x3 - f1)
C
*     FUNCTION ae_r2
      ae_r2 = V*x4_z + psi*(x4 - f2)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION xs1_0
      xs1_0 = init
C
*     FUNCTION xs2_0
      xs2_0 = init
C
*     FUNCTION xs3_0
      xs3_0 = init
C
*     FUNCTION xs4_0
      xs4_0 = init
C
*     FUNCTION xr1_0
      xr1_0 = init
C
*     FUNCTION xr2_0
      xr2_0 = init
C
*     FUNCTION xr3_0
      xr3_0 = init
C
*     FUNCTION xr4_0
      xr4_0 = init
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
*     FUNCTION xb1_t
      fb1 = 1.18*xb1/(0.18*xb1 + 0.58*xb2 + 0.42)
      xb1_t = ((L+F)*x1 + (L+F-V)*xb1 - V*fb1)/Hb
C
*     FUNCTION xb2_t
      fb2 = xb2/(0.18*xb1 + 0.58*xb2 + 0.42)
      xb2_t = ((L+F)*x2 + (L+F-V)*xb2 - V*fb2)/Hb
C
*     FUNCTION xc1_t
      xc1_t = V*(xc30 - xc1)/Hc
C
*     FUNCTION xc2_t
      xc2_t = V*(xc40 - xc2)/Hc
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION xb1_0
      xb1_0 = init
C
*     FUNCTION xb2_0
      xb2_0 = init
C
*     FUNCTION xc1_0
      xc1_0 = init
C
*     FUNCTION xc2_0
      xc2_0 = init
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION xs1_left
      xs1_left = (L*xr10 + F*x1f)/(L+F)
C
*     FUNCTION xs2_left
      xs2_left = (L*xr20 + F*x2f)/(L+F)
C
*     FUNCTION xs3_left
      fb1 = 1.18*xb1/(0.18*xb1 + 0.58*xb2 + 0.42)
      xs3_left = fb1
C
*     FUNCTION xs4_left
      fb2 = xb2/(0.18*xb1 + 0.58*xb2 + 0.42)
      xs4_left = fb2
C
*     FUNCTION xr1_left
      xr1_left = xr10
C
*     FUNCTION xr2_left
      xr2_left = xr20
C
*     FUNCTION xr3_left
      xr3_left = x3
C
*     FUNCTION xr4_left
      xr4_left = x4
C
*     FUNCTION xr1_right
      xr1_right = xc1
C
*     FUNCTION xr2_right
      xr2_right = xc2
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
C*     FUNCTION UXL
C      UXL = ...
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT(i), i in ind
      FIT(i) = x1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
