C
C------------------------------------------------------
C
C     Problem:    MCSTILLX
C
C     Date:       2.07.2003
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      BF=0.6
      TF=0.25       
      R=5                
      B00=0.967
      B10=0.914
      B20=0.813
      B30=0.651
      B40=0.457
      B50=0.289
      B60=0.137
      B70=0.56E-1
      B80=0.20E-1
      B90=0.60E-2
      T00=0.325E-1
      T10=0.849E-1
      T20=0.185
      T30=0.343
      T40=0.522
      T50=0.649
      T60=0.781
      T70=0.817
      T80=0.755
      T90=0.594  
      A3=0.4 
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      A1, A2, V1
      M0, M9, M
      FEED1, FEED2, FEED3, FEED4, FEED5
      FEED6, FEED7, FEED8, FEED9, FEED10
      B0, B1, B2, B3, B4, B5, B6, B7, B8, B9
      T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION B0P
      IF (T.LT.5) THEN
        F=FEED1
      ELSE  
      IF (T.LT.10) THEN
        F=FEED2
      ELSE  
      IF (T.LT.15) THEN
        F=FEED3
      ELSE  
      IF (T.LT.20) THEN
        F=FEED4
      ELSE  
      IF (T.LT.25) THEN
        F=FEED5
      ELSE  
      IF (T.LT.30) THEN
        F=FEED6
      ELSE  
      IF (T.LT.35) THEN
        F=FEED7
      ELSE  
      IF (T.LT.40) THEN
        F=FEED8
      ELSE  
      IF (T.LT.45) THEN
        F=FEED9
      ELSE      
        F=FEED10
      ENDIF
      ENDIF
      ENDIF
      ENDIF
      ENDIF
      ENDIF
      ENDIF
      ENDIF      
      ENDIF
      V=V1
      D=V/(R+1)
      L=V-D
      L1=L+F
      W=L1-V1 
      X0=1-B0-T0  
      X1=1-B1-T1  
      X2=1-B2-T2  
      X3=1-B3-T3  
      X4=1-B4-T4  
      X5=1-B5-T5  
      X6=1-B6-T6  
      X7=1-B7-T7  
      X8=1-B8-T8  
      X9=1-B9-T9  
      F1=A1*B1+A2*T1+A3*X1
      F2=A1*B2+A2*T2+A3*X2
      F3=A1*B3+A2*T3+A3*X3
      F4=A1*B4+A2*T4+A3*X4
      F5=A1*B5+A2*T5+A3*X5
      F6=A1*B6+A2*T6+A3*X6
      F7=A1*B7+A2*T7+A3*X7
      F8=A1*B8+A2*T8+A3*X8
      F9=A1*B9+A2*T9+A3*X9
      VB1=A1*B1/F1
      VT1=A2*T1/F1
      VB2=A1*B2/F2
      VT2=A2*T2/F2
      VB3=A1*B3/F3
      VT3=A2*T3/F3
      VB4=A1*B4/F4
      VT4=A2*T4/F4
      VB5=A1*B5/F5
      VT5=A2*T5/F5
      VB6=A1*B6/F6
      VT6=A2*T6/F6
      VB7=A1*B7/F7
      VT7=A2*T7/F7
      VB8=A1*B8/F8
      VT8=A2*T8/F8
      VB9=A1*B9/F9
      VT9=A2*T9/F9
      B0P=(V*VB1-(L+D)*B0)/M0 
C
*     FUNCTION B1P
      B1P=(L*(B0-B1)+V*(VB2-VB1))/M   
C
*     FUNCTION B2P
      B2P=(L*(B1-B2)+V*(VB3-VB2))/M   
C
*     FUNCTION B3P
      B3P=(L*(B2-B3)+V*(VB4-VB3))/M   
C
*     FUNCTION B4P
      B4P=(L*(B3-B4)+V*(VB5-VB4))/M   
C
*     FUNCTION B5P
      B5P=(F*BF+L*B4-L1*B5+V1*VB6-V*VB5)/M 
C
*     FUNCTION B6P
      B6P=(L1*(B5-B6)+V1*(VB7-VB6))/M 
C
*     FUNCTION B7P
      B7P=(L1*(B6-B7)+V1*(VB8-VB7))/M 
C
*     FUNCTION B8P
      B8P=(L1*(B7-B8)+V1*(VB9-VB8))/M 
C
*     FUNCTION B9P
      B9P=(L1*B8-V1*VB9-W*B9)/M9  
C
*     FUNCTION T0P
      T0P=(V*VT1-(L+D)*T0)/M0 
C
*     FUNCTION T1P
      T1P=(L*(T0-T1)+V*(VT2-VT1))/M   
C
*     FUNCTION T2P
      T2P=(L*(T1-T2)+V*(VT3-VT2))/M   
C
*     FUNCTION T3P
      T3P=(L*(T2-T3)+V*(VT4-VT3))/M   
C
*     FUNCTION T4P
      T4P=(L*(T3-T4)+V*(VT5-VT4))/M   
 C
*     FUNCTION T5P
      T5P=(F*TF+L*T4-L1*T5+V1*VT6-V*VT5)/M 
C
*     FUNCTION T6P
      T6P=(L1*(T5-T6)+V1*(VT7-VT6))/M 
C
*     FUNCTION T7P
      T7P=(L1*(T6-T7)+V1*(VT8-VT7))/M 
C
*     FUNCTION T8P
      T8P=(L1*(T7-T8)+V1*(VT9-VT8))/M 
C
*     FUNCTION T9P
      T9P=(L1*T8-V1*VT9-W*T9)/M9  
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION B0_0
      IF (T.LT.0.1) THEN
        B0_0=B00
      ELSE
        B0_0=B0
      ENDIF
C
*     FUNCTION B1_0
      IF (T.LT.0.1) THEN
        B1_0=B10
      ELSE
        B1_0=B1
      ENDIF
C
*     FUNCTION B2_0
      IF (T.LT.0.1) THEN
        B2_0=B20
      ELSE
        B2_0=B2
      ENDIF
C
*     FUNCTION B3_0
      IF (T.LT.0.1) THEN
        B3_0=B30
      ELSE
        B3_0=B3
      ENDIF
C
*     FUNCTION B4_0
      IF (T.LT.0.1) THEN
        B4_0=B40
      ELSE
        B4_0=B4
      ENDIF
C
*     FUNCTION B5_0
      IF (T.LT.0.1) THEN
        B5_0=B50
      ELSE
        B5_0=B5
      ENDIF
C
*     FUNCTION B6_0
      IF (T.LT.0.1) THEN
        B6_0=B60
      ELSE
        B6_0=B6
      ENDIF
C
*     FUNCTION B7_0
      IF (T.LT.0.1) THEN
        B7_0=B70
      ELSE
        B7_0=B7
      ENDIF
C
*     FUNCTION B8_0
      IF (T.LT.0.1) THEN
        B8_0=B80
      ELSE
        B8_0=B8
      ENDIF
C
*     FUNCTION B9_0
      IF (T.LT.0.1) THEN
        B9_0=B90
      ELSE
        B9_0=B9
      ENDIF
C
*     FUNCTION T0_0
      IF (T.LT.0.1) THEN
        T0_0=T00
      ELSE
        T0_0=T0
      ENDIF
C
*     FUNCTION T1_0
      IF (T.LT.0.1) THEN
        T1_0=T10
      ELSE
        T1_0=T1
      ENDIF
C
*     FUNCTION T2_0
      IF (T.LT.0.1) THEN
        T2_0=T20
      ELSE
        T2_0=T2
      ENDIF
C
*     FUNCTION T3_0
      IF (T.LT.0.1) THEN
        T3_0=T30
      ELSE
        T3_0=T3
      ENDIF
C
*     FUNCTION T4_0
      IF (T.LT.0.1) THEN
        T4_0=T40
      ELSE
        T4_0=T4
      ENDIF
C
*     FUNCTION T5_0
      IF (T.LT.0.1) THEN
        T5_0=T50
      ELSE
        T5_0=T5
      ENDIF
C
*     FUNCTION T6_0
      IF (T.LT.0.1) THEN
        T6_0=T60
      ELSE
        T6_0=T6
      ENDIF
C
*     FUNCTION T7_0
      IF (T.LT.0.1) THEN
        T7_0=T70
      ELSE
        T7_0=T7
      ENDIF
C
*     FUNCTION T8_0
      IF (T.LT.0.1) THEN
        T8_0=T80
      ELSE
        T8_0=T8
      ENDIF
C
*     FUNCTION T9_0
      IF (T.LT.0.1) THEN
        T9_0=T90
      ELSE
        T9_0=T9
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION B0_fit
      B0_fit=B0
C
*     FUNCTION B1_fit
      B1_fit=B1
C
*     FUNCTION B2_fit
      B2_fit=B2
C
*     FUNCTION B3_fit
      B3_fit=B3
C
*     FUNCTION B4_fit
      B4_fit=B4
C
*     FUNCTION B5_fit
      B5_fit=B5
C
*     FUNCTION B6_fit
      B6_fit=B6
C
*     FUNCTION B7_fit
      B7_fit=B7
C
*     FUNCTION B8_fit
      B8_fit=B8
C
*     FUNCTION B9_fit
      B9_fit=B9       
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
