C
C------------------------------------------------------
C  
C     Problem:    MCMC_0
C  
C     Date:       18.06.2002
C  
C------------------------------------------------------
C  
*     PARAMETER
      n = 7
C  
C------------------------------------------------------
C  
*     SET OF INDICES
      ind = 1..n
C  
C------------------------------------------------------
C  
*     REAL CONSTANT
      cpa = 1
      cpc = 0.1
      cpt = 4
      cps = 500
      DTad_ref = -18
      DTad_ox = 22
      DTad_red = 3
      Da_ref = 1
      Da_ox = 100
      Da_red = 100
      DaII_ref = 1000
      DaII_ox = 1000
      DaII_red = 1000
      Ea_ref = 5
      Ea_ox = 5
      Ea_red = 5
      K_ref = 1
      St_ac = 100
      St_cs = 100
      Fl = 8/3.5
      alpha_ox = 0.5
      alpha_red = 0.5
      Dphia = -13
      Dphie = -0.1
      Dphic = 11
      kappa = 0.1
      lambda = 3
C  
C------------------------------------------------------
C  
*     TABLE nu_ref(i), i in ind
      1  -1.0
      2  -2.0
      3   4.0
      4   0.0
      5   1.0
      6   0.0
      7   0.0
C  
*     TABLE nu_ox(i), i in ind
      1   0.0
      2   1.0
      3  -1.0
      4   0.0
      5   1.0
      6   0.0
      7   0.0
C  
*     TABLE nu_red(i), i in ind
      1   0.0
      2   0.0
      3   0.0
      4   0.0
      5   1.0
      6   0.5
      7   0.0
C  
*     TABLE xa_in(i), i in ind
      1  0.286
      2  0.7143
      3  0.0
      4  0.01
      5  0.0
      6  0.025
      7  0.031
C  
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables identifying solution of coupled
C        differential algebraic equations, e.g. implicit
C        boundary conditions (w)
C     7. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDAE.
C     8. spatial variable (x)
C     9. time variable (t)
C  
*     VARIABLE
      nub_ref, nub_ox, nub_red, n_ox, n_red 
      Ta, Ts, Tc 
      xa(i), i in ind
      xc(i), i in ind 
      ga, gc 
      Ta_z, Ts_z, Tc_z 
      xa_z(i), i in ind
      xc_z(i), i in ind 
      ga_z, gc_z 
      Ta_zz, Ts_zz, Tc_zz 
      xa_zz(i), i in ind
      xc_zz(i), i in ind 
      ga_zz, gc_zz 
      Tc_zu 
      xc_zu(i), i in ind
      gc_zu 
      z, t
C  
C------------------------------------------------------
C  
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C  *     FUNCTION flux
C        flux = ...
C  
C------------------------------------------------------
C  
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C  
*     FUNCTION Ta_t
      if (Ta.gt.0) then
        R_ref = exp(EA_ref*(1 - 1/Ta))*(xa(1)*xa(2)**2 - 
     /                                  xa(5)*xa(3)**4/K_ref) 
      else
        R_ref = 0
      endif
      q_as = St_ac*(Ts - Ta) 
      Ta_t = (-ga*cpa*Ta_z + Dtad_ref*Da_ref*R_ref + q_as)*Ta/cpa
C  
*     FUNCTION Ts_t
      if (Ts.gt.0) then
        wa = DaII_ox*exp(-EA_ox/Ts)*exp(alpha_ox*n_ox/Ts*Dphia)
        wc = DaII_red*exp(-EA_red/Ts)*exp(-alpha_red*n_red/Ts*Dphic)
      else
        wa = 0
        wc = 0
      endif
      ia = xa(3)*wa/(1 + wa)
      if (xc(6).gt.0) then
        sxc6 = sqrt(xc(6))
      else
        sxc6 = 0
      endif
      ic = xc(5)*sxc6*wc/(1 + wc)
      ie = -Dphie/kappa
      DTburn = DTad_ox*Fl/n_ox*ia - DTad_red*Fl/n_red*ic +
     /              Fl/cpt*(Dphia*ia - Dphic*ic - Dphie*ie)
      ii = 0
      q_cs = St_cs*(Ts - Tc) 
      Ts_t = (lambda*Ts_zz + DTburn*ii - q_as - q_cs)/cps
C  
*     FUNCTION Tc_t
      Tc_t = (gc*cpc*Tc_z + q_cs)*Tc/cpc
C  
*     FUNCTION xa_t(i), i in ind 
      xa_t(i) = (-ga*xa_z(i) + (nu_ox(i)  - xa(i)*nub_ox)*Fl/n_ox*ia
     /             + (nu_ref(i) - xa(i)*nub_ref)*Da_ref*R_ref)*Ta
C  
*     FUNCTION xc_t(i), i in ind 
      xc_t(i) = (-gc*xc_z(i) 
     /             - (nu_red(i)  - xc(i)*nub_red)*Fl/n_red*ic)*Tc
C  
*     FUNCTION equa
      if (Ts.gt.0) then
        wa = DaII_ox*exp(-EA_ox/Ts)*exp(alpha_ox*n_ox/Ts*Dphia)
        wc = DaII_red*exp(-EA_red/Ts)*exp(-alpha_red*n_red/Ts*Dphic)
      else
        wa = 0
        wc = 0
      endif
      ia = xa(3)*wa/(1 + wa)
      if (xc(6).gt.0) then
        sxc6 = sqrt(xc(6))
      else
        sxc6 = 0
      endif
      ic = xc(5)*sxc6*wc/(1 + wc)
      ie = -Dphie/kappa
      if (Ta.gt.0) then
        R_ref = exp(EA_ref*(1 - 1/Ta))*(xa(1)*xa(2)**2 - 
     /                                      xa(5)*xa(3)**4/K_ref) 
      else
        R_ref = 0
      endif
      q_as = St_ac*(Ts - Ta) 
      Tat = (-ga*cpa*Ta_z + Dtad_ref*Da_ref*R_ref + q_as)*Ta/cpa
      equa = (ga_z - nub_ref*Da_ref*R_ref - nub_ox*Fl/n_ox*ia)*Ta**2
     /                   - Tat
C  
*     FUNCTION equc
      q_cs = St_cs*(Ts - Tc) 
      Tct = (gc*cpc*Tc_z + q_cs)*Tc/cpc
      equc = (-gc_z + nub_red*Fl/n_red*ic)*Tc**2 - Tct
C  
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C  
*     FUNCTION Ta_0
      Ta_0 = 0.5
C
*     FUNCTION Ts_0
      Ts_0 = 1
C
*     FUNCTION Tc_0
      Tc_0 = 1
C
*     FUNCTION xa_0(i), i in ind
      xa_0(i) = xa_in(i) 
C
*     FUNCTION xc_0(i), i in ind
      xc_0(i) = xa_in(i) 
C
*     FUNCTION ga_0
      ga_0 = 1
C
*     FUNCTION gc_0
      gc_0 = 1
C      
C------------------------------------------------------
C  
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C  *     FUNCTION v_t
C        v_t = ...
C  
C------------------------------------------------------
C  
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C  
C *     FUNCTION v_0
C       v_0 = ...
C  
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled differential algebraic equations, order 
C     defined by increasing spatial positions (e.g. 
C     implicit boundary conditions):
C
*     FUNCTION equT
      equT = Ta - Tc_zu
C  
*     FUNCTION equx(i), i in ind
      equx(i) = xa(i) - xc_zu(i)
C  
*     FUNCTION equg
      equg = ga - gc_zu
C  
C------------------------------------------------------
C
C   - Initial values of system of coupled differential
C     algebraic equations for t=0 in the same order:
C    
*     FUNCTION Tc_zu_0
      Tc_zu_0 = 0
C  
*     FUNCTION xc_zu_0(i), i in ind
      xc_zu_0(i) = 0
C  
*     FUNCTION gc_zu_0
      gc_zu_0 = 0
C  
C------------------------------------------------------
C  
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C  
*     FUNCTION Ta_left
      Ta_left = 0.5
C  
*     FUNCTION Tc_left
      Tc_left = Tc_zu
C  
*     FUNCTION xa_left(i), i in ind
      xa_left(i) = xa_in(i)
C  
*     FUNCTION xc_left(i), i in ind
      xc_left(i) = xc_zu(i)
C  
*     FUNCTION ga_left
      ga_left = 1
C  
*     FUNCTION gc_left
      gc_left = gc_zu
C  
C------------------------------------------------------
C  
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C  
*     FUNCTION Ts_z_left
      Ts_z_left = 0
C  
*     FUNCTION Ts_z_right
      Ts_z_right = 0
C  
C------------------------------------------------------
C  
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C  
*     FUNCTION fit(i), i in ind
      fit(i) = xc(i)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C  
C  *     FUNCTION g1
C        g1 = ...
C
C------------------------------------------------------
C  
*     END
C  
C------------------------------------------------------
C
