C
C------------------------------------------------------
C
C     Problem:    MCFC1
C
C     Date:       6.11.2002
C
C------------------------------------------------------
C
*     PARAMETER
      n = 7
      nfit = 20
      anz_ox = 2
      anz_ref = 2
      anz_red = 1
      anz_ctrl = 10
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
      indox = 1..anz_ox
      indred = 1..anz_red
      indref = 1..anz_ref
      indctrl = 1..anz_ctrl
      indfit = 1..nfit
C
C------------------------------------------------------
C
*     INDEX
      j
      m
C
C------------------------------------------------------
C
*     REAL CONSTANT
      cpi = 30
      cps = 10000
      St_ac = 100
      St_cc = 100
      lambda_s = 5
      FI = 8/3.5
      kappa = 0.1
      Dphia = -22
      Dphie = -1
      Dphic = 10
      ie = -Dphie/kappa
c      Ta_in = 3
      Ta0 = 3.0
      Tc_in = 3.5
c      ga_in = 1
      gc_in = 7
      Ts_AB = 3
      Tc_AB = 3
      lambda_Luft = 2
      x_O2Luft = 0.21
      theta_Luft = 1
      cp_VB = 30
      St_v = 100
      theta_u = 1
C
C------------------------------------------------------
C
*     TABLE DTad_ref(i), i in indref
      1 -100.0
      2  10.0
C
*     TABLE DTad_ox(i), i in indox
      1  100.0
      2  100.0
C
*     TABLE DTad_red(i), i in indred
      1  15.0
C
*     TABLE K_ref(i), i in indref
      1   0.5
      2   0.5
C
*     TABLE DaII_ox(i), i in indox
      1   1.0
      2   1.0
C
*     TABLE DaII_red(i), i IN indred
      1   1.0
C
*     TABLE n_ox(i), i in indox
      1   2.0
      2   2.0 
C
*     TABLE n_red(i), i in indred
      1   2.0
C
*     TABLE alpha_ox(i), i in indox
      1   0.5
      2   0.5
C
*     TABLE alpha_red(i), i in indred
      1   0.5
C
*     TABLE Da_ref(i), i in indref
      1   1.0
      2   1.0
C
*     TABLE Da_ox(i), i in indox
      1   100.0
      2   100.0
C
*     TABLE Da_red(i), i in indred
      1   30.0
C
*     TABLE EA_ref(i), i IN indref
      1   5.0
      2   5.0
C
*     TABLE EA_ox(i), i in indox
      1   5.0
      2   5.0
C
*     TABLE EA_red(i), i in indred
      1   5.0
C
*     TABLE nub_ref(i), i in indref
      1   2.0
      2   0.0
C
*     TABLE nub_ox(i), i in indox
      1   1.0
      2   1.0
C
*     TABLE nub_red(i), i in indred
      1   1.5
C
*     TABLE nu_ref(k,i), k in indref, i in ind
      1 1  -1.0
      1 2  -1.0
      1 3   3.0
      1 4   1.0
      1 5   0.0
      1 6   0.0
      1 7   0.0
      2 1   0.0
      2 2  -1.0
      2 3   1.0
      2 4  -1.0
      2 5   1.0
      2 6   0.0
      2 7   0.0
C
*     TABLE nu_red(k,i), k in indred, i in ind
      1 1   0.0
      1 2   0.0
      1 3   0.0
      1 4   0.0
      1 5   1.0
      1 6   0.5
      1 7   0.0
C
*     TABLE nu_ox(k,i), k in indox, i in ind
      1 1   0.0
      1 2   1.0
      1 3  -1.0
      1 4   0.0
      1 5   1.0
      1 6   0.0
      1 7   0.0
      2 1   0.0
      2 2   0.0
      2 3   0.0
      2 4  -1.0
      2 5   2.0
      2 6   0.0
      2 7   0.0
C
*     TABLE xa_in(i), i in ind
      1  0.2857
      2  0.7143
      3  0.0
      4  0.0
      5  0.0
      6  0.0
      7  0.0
C
*     TABLE xc_in(i), i in ind
      1 0.0
      2 0.19
      3 0.0
      4 0.0
      5 0.07
      6 0.10
      7 0.64
C
*     TABLE xa_AB(i), i in ind
      1 0.03
      2 0.37
      3 0.35
      4 0.0
      5 0.25
      6 0.0
      7 0.0
C
*     TABLE xc_AB(i), i in ind
      1 0.0
      2 0.24
      3 0.0
      4 0.0
      5 0.05
      6 0.06
      7 0.65
C
*     TABLE DTadv(i), i IN ind
      1  300.0
      2  0.0
      3  100.0
      4  100.0
      5  0.0
      6  0.0
      7  0.0
C      
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables identifying solution of coupled
C        differential algebraic equations, e.g. implicit
C        boundary conditions (w)
C     7. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDAE.
C     8. spatial variable (x)
C     9. time variable (t)
C
*     VARIABLE
      Ta_in(i), i in indctrl
      ga_in(i), i in indctrl
      Ta, Ts, Tc 
      xa(i), i in ind
      xc(i), i in ind 
      ga, gc 
      Ta_z, Ts_z, Tc_z 
      xa_z(i), i in ind
      xc_z(i), i in ind 
      ga_z, gc_z 
      Ta_zz, Ts_zz, Tc_zz 
      xa_zz(i), i in ind
      xc_zz(i), i in ind 
      ga_zz, gc_zz
      z, t
C
C------------------------------------------------------
C
*     MACRO cpa
      cpa = cpi*SUM(xa(i), i IN ind)
C
*     MACRO cpc
      cpc = cpi*SUM(xc(i), i IN ind)
C
*     MACRO R_ref1
      if (Ta.gt.0) then
          R_ref1 = exp(EA_ref(1)*(1 - 1/Ta))*(xa(1)*xa(2) - 
     /             xa(4)*xa(3)**3/K_ref(1)) 
      else
          R_ref1 = 0
      endif
C
*     MACRO R_ref2
      if (Ta.gt.0) then
          R_ref2 = exp(EA_ref(2)*(1 - 1/Ta))*(xa(4)*xa(2) - 
     /             xa(5)*xa(3)/K_ref(2)) 
      else
          R_ref2 = 0
      endif
C
*     MACRO R_ox1
      if (Ts.gt.0) then
c         waa = DaII_ox(1)*exp(EA_ox(1)*(1-1/Ts))*exp(alpha_ox(1)
c     /         *n_ox(1)/Ts*Dphia)
         wa = exp(EA_ox(1)*(1-1/Ts))*exp(alpha_ox(1)*n_ox(1)/Ts*Dphia)
         waa = DaII_ox(1)*wa
      else
         waa = 0
         wa = 0
      endif  
      R_ox1 = xa(3)*wa/(1+waa)
C
*     MACRO R_ox2
      if (Ts.gt.0) then
c         waa = DaII_ox(2)*exp(EA_ox(2)*(1-1/Ts))*exp(alpha_ox(2)
c     /         *n_ox(2)/Ts*Dphia)
         wa = exp(EA_ox(2)*(1-1/Ts))*exp(alpha_ox(2)
     /         *n_ox(2)/Ts*Dphia)
         waa = DaII_ox(2)*wa
      else
         waa = 0
         wa = 0
      endif 
      R_ox2 = xa(4)*wa/(1+waa)
C
*     MACRO R_red1
      if (Ts.gt.0) then
c         wcc = DaII_red(1)*exp(EA_red(1)*(1-1/Ts))*
c     /         exp(-alpha_red(1)*n_red(1)/Ts*Dphic)
         wc = exp(EA_red(1)*(1-1/Ts))*exp(-alpha_red(1)*
     /        n_red(1)/Ts*Dphic) 
         wcc = DaII_red(1)*wc
      else
         wcc = 0
         wc = 0
      endif    
      if (xc(6).gt.0) then
         sxc6 = sqrt(xc(6))
      else
         sxc6 = 0
      endif
      R_red1 = -xc(5)*sxc6*wc/(1+wcc*sxc6)
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION Ta_t
      w1 = 0.5*cpi*Da_ox(1)*R_ox1*(Ts-Ta)
      w2 = 0.5*cpi*Da_ox(2)*R_ox2*(Ts-Ta)
      q_as = St_ac*(Ts - Ta) 
     /       + sum((nu_ox(1,i)+abs(nu_ox(1,i)))*w1, i in ind)
     /       + sum((nu_ox(2,i)+abs(nu_ox(2,i)))*w2, i in ind)
      q_sa = q_as - 2*St_ac*(Ts - Ta)
      w1 = 0.5*Da_red(1)*R_red1*cpi*(Tc - Ts)
      q_sc = -St_cc*(Ts-Tc)
     /       - sum((nu_red(1,i)-abs(nu_red(1,i)))*w1, i in ind)
      q_cs = q_sc + 2*St_cc*(Ts - Tc)
C
      Ta_t = (-ga*cpa*Ta_z + 
     /       DTad_ref(1)*Da_ref(1)*R_ref1 + 
     /       DTad_ref(2)*Da_ref(2)*R_ref2 + q_as)*Ta/cpa
C
*     FUNCTION Ts_t
      q_solid = (DTad_ox(1)+n_ox(1)*Dphia)*Da_ox(1)*R_ox1 +
     /          (DTad_ox(2)+n_ox(2)*Dphia)*Da_ox(2)*R_ox2 +
     /          (DTad_red(1)+n_red(1)*Dphic)*Da_red(1)*R_red1
     /           -Dphie*ie*FI
      Ts_t = (lambda_s*Ts_zz + q_solid + q_sa + q_sc)/cps
C
*     FUNCTION Tc_t
      Tc_t = (gc*cpc*Tc_z + q_cs)*Tc/cpc
C
*     FUNCTION xa_t(i), i in ind 
      xa_t(i)=(-ga*xa_z(i) + 
     /        (nu_ox(1,i)-xa(i)*nub_ox(1))*Da_ox(1)*R_ox1 +
     /        (nu_ox(2,i)-xa(i)*nub_ox(2))*Da_ox(2)*R_ox2 +
     /        (nu_ref(1,i)-xa(i)*nub_ref(1))*Da_ref(1)*R_ref1 +
     /        (nu_ref(2,i)-xa(i)*nub_ref(2))*Da_ref(2)*R_ref2)
     /        *Ta
C
*     FUNCTION xc_t(i), i in ind 
      xc_t(i)=(gc*xc_z(i) + 
     /        (nu_red(1,i)-xc(i)*nub_red(1))*Da_red(1)*R_red1)
     /        *Tc
C
*     FUNCTION equa
      w1 = 0.5*cpi*Da_ox(1)*R_ox1*(Ts-Ta)
      w2 = 0.5*cpi*Da_ox(2)*R_ox2*(Ts-Ta)
      q_as = St_ac*(Ts - Ta) 
     /       + sum((nu_ox(1,i)+abs(nu_ox(1,i)))*w1, i in ind)
     /       + sum((nu_ox(2,i)+abs(nu_ox(2,i)))*w2, i in ind)
      q_sa = q_as - 2*St_ac*(Ts - Ta)
      w1 = 0.5*Da_red(1)*R_red1*cpi*(Tc - Ts)
      q_sc = -St_cc*(Ts - Tc)
     /       - sum((nu_red(1,i)-abs(nu_red(1,i)))*w1, i in ind)
      q_cs = q_sc + 2*St_cc*(Ts - Tc)
C
      Tat = (-ga*cpa*Ta_z + 
     /      DTad_ref(1)*Da_ref(1)*R_ref1 +
     /      DTad_ref(2)*Da_ref(2)*R_ref2 + q_as)/cpa
      equa = (-ga_z + nub_ref(1)*Da_ref(1)*R_ref1 +
     /       nub_ref(2)*Da_ref(2)*R_ref2 +
     /       nub_ox(1)*Da_ox(1)*R_ox1 +
     /       nub_ox(2)*Da_ox(2)*R_ox2)*Ta + Tat
C
*     FUNCTION equc
      Tct = (-gc*cpc*Tc_z + q_cs)/cpc
      equc = (-gc_z + nub_red(1)*Da_red(1)*R_red1)*Tc + Tct
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION Ta_0
      if (t.lt.0.0001) then
        Ta_0 = Ta0
      else
        Ta_0 = Ta
      endif
C
*     FUNCTION Ts_0
      if (t.lt.0.0001) then
        Ts_0 = Ts_AB
      else
        Ts_0 = Ts
      endif
C
*     FUNCTION Tc_0
      if (t.lt.0.0001) then
        Tc_0 = Tc_AB
      else
        Tc_0 = Tc
      endif
C
*     FUNCTION xa_0(i), i in ind
      if (t.lt.0.0001) then
        xa_0(i) = xa_AB(i) 
      else
        xa_0(i) = xa(i) 
      endif
C
*     FUNCTION xc_0(i), i in ind
      if (t.lt.0.0001) then
        xc_0(i) = xc_AB(i) 
      else
        xc_0(i) = xc(i) 
      endif
C
*     FUNCTION ga_0
      if (t.lt.0.0001) then
        ga_0 = 1
      else
        ga_0 = ga
      endif
C
*     FUNCTION gc_0
      if (t.lt.0.0001) then
        gc_0 = 7
      else
        gc_0 = gc
      endif
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION Ta_left
      Ta_left = 0
      j = 1
 1000 continue
      t_ctrl = j*0.5/anz_ctrl
      if (j.eq.anz_ctrl) then
        t_ctrl = 0.50001
      endif
      if (t.lt.t_ctrl) then
        Ta_left = Ta_in(j)
        goto 1100
      endif
      j = j+1
      if (j.le.anz_ctrl) then
        goto 1000
      endif
 1100 continue
C
*     FUNCTION xa_left(i), i in ind
      xa_left(i) = xa_in(i)
C
*     FUNCTION ga_left
      ga_left = 0
      j = 1
 2000 continue
      t_ctrl = j*0.5/anz_ctrl
      if (j.eq.anz_ctrl) then
        t_ctrl = 0.50001
      endif
      if (t.lt.t_ctrl) then
        ga_left = ga_in(j)
        goto 2100
      endif
      j = j+1
      if (j.le.anz_ctrl) then
        goto 2000
      endif
 2100 continue
C
*     FUNCTION Tc_right
      gLuft = (lambda_luft*(xa(1)*2+xa(3)/2+xa(4)/2)-
     /                    xa(6))*ga/x_O2Luft
      gvab = ga*(1-xa(4)/2-xa(3)/2)+gLuft
      Tvab = (gLuft*theta_Luft+ga*
     /             (Ta+sum(xa(i)*DTadv(i),i IN ind)/cp_VB))/gvab
      Tc_right = (gvab*cp_VB*Tvab+St_v*theta_u)/(gvab*cp_VB+St_v)
C
*     FUNCTION xc_right1
      xc_right1 = 0
C
*     FUNCTION xc_right2
      xc_right2 = (2*xa(1)+xa(3)+xa(2))*ga/gvab
C
*     FUNCTION xc_right3
      xc_right3 = 0
C
*     FUNCTION xc_right4
      xc_right4 = 0
C
*     FUNCTION xc_right5
      xc_right5 = (xa(1)+xa(4)+xa(5))*ga/gvab
C
*     FUNCTION xc_right6
      xc_right6 = ((xa(6)-2*xa(1)-xa(3)/2-xa(4)/2)*ga+gLuft*x_O2Luft)/
     /            gvab
C
*     FUNCTION xc_right7
      xc_right7 = (xa(7)*ga+gLuft*(1-x_O2Luft))/gvab
C
*     FUNCTION gc_right
      gc_right = gvab
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION Ts_z_left
      Ts_z_left = 0
C
*     FUNCTION Ts_z_right
      Ts_z_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit(i), i in indfit
      fit(i) = Ta 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



