C
C------------------------------------------------------
C
C     Problem:    MARINE
C
C     Date:       13.03.2001
C
C------------------------------------------------------
C
*     PARAMETER
      ns = 8
      ns1 = 7
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..ns
      ind2 = 1..ns1
C
C------------------------------------------------------
C
*     TABLE yini(j), j in ind
      1  20000.0 
      2  17000.0 
      3  10000.0 
      4  15000.0 
      5  12000.0
      6   9000.0
      7   7000.0
      8   3000.0
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      m(j), j in ind
      g(j), j in ind
      y(j), j in ind
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION yp1
      yp1 =  -m(1)*y(1)     
C   
*     FUNCTION yp(j), j in ind2
      yp(j) = y(j)*g(j) - (m(j+1) + g(j+1))*y(j+1)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y0(j), j in ind
      y0(j) = yini(j)
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION yfit(j), j in ind
      yfit(j) = y(j)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


