C
C------------------------------------------------------
C
C     Problem:    MARBLE
C
C     Date:       18.11.2003
C
C------------------------------------------------------
C            
*     REAL CONSTANT
      m = 1
      g = 9.8      
C
C------------------------------------------------------
C            
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      v, h, x, y, z, vx, vy, vz, lambda, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t
      x_t = vx
C
*     FUNCTION y_t
      y_t = vy
C
*     FUNCTION z_t
      z_t = vz
C
*     FUNCTION vx_t
      vx_t = -2/m*x*lambda
C
*     FUNCTION vy_t
      vy_t = -2/m*y*lambda
C
*     FUNCTION vz_t
      vz_t = -g + lambda/m
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION alg_equ
      alg_equ = x**2 + y**2 - z               
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = 0
C
*     FUNCTION y_0
      y_0 = sqrt(h)
C
*     FUNCTION z_0
      z_0 = h
C
*     FUNCTION vx_0
      vx_0 = v
C
*     FUNCTION vy_0
      vy_0 = 0
C
*     FUNCTION vz_0
      vz_0 = 0
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION lambda_0
      lambda_0 = m*(v**2 + g)/(2*h + 1)
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION y_fit
      y_fit = y
C
*     FUNCTION z_fit
      z_fit = z
C
*     FUNCTION lambda_fit
      lambda_fit = lambda
C
*     FUNCTION equation
      equation = x**2 + y**2 - z
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
