C
C------------------------------------------------------
C
C     Problem:    MALTODEX
C
C     Date:       16.06.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      D_scale = 1.0E-8
      P2 = 0
      L = 0.0020954
      aw = 0.621
      ms = 0.00152 
      T0 = 42.10848
      C1 = 17.44
      Pi = 3.1415926535
      TgMD12 = 164 
      TgH20 = -135
      k = 7.64
      A0 = Pi*0.25*0.0493**2
      Cps = 1500 
      Cpw = 4186.8
C
C------------------------------------------------------
C
*     SPLINE Tdb
          0.0   42.10848  
       2900.0   71.68918  
       4500.0   70.06306  
       7000.0   70.69259  
       9500.0   71.13257  
      12800.0   72.35349  
      14000.0   73.45349  
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      Dr, P1, Tr, C2, Mw0, Mw, Mw_x, Mw_xx, T, f, f_x, x, time
C
*     FUNCTION flux
      Xw = Mw/(1 + Mw)
      XMD121 = 1 - Xw
      Tg = (XMD121*TgMD12 + k*Xw*TgH20)/(XMD121 + k*Xw)
      Diff = Dr*D_scale*10**(C1*C2*(T - Tr)
     /     /((C2 + T - Tg)*(C2 - Tg + Tr)))
      flux = Diff*Mw_x/L
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION Mw_t
      Mw_t = f_x/L
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION Mw_0
      if (time.lt.1) then
        Mw_0 = Mw0/L
      else       
        Mw_0 = Mw
      endif  
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
*     FUNCTION T_t
      Mw_mean = SIMPSN(1,1)
      alfa = ms*Cps + ms*Mw_mean*Cpw
      hA = A0*(P1*Mw_mean + P2)
      lambda = 3114979.2 - 2248.3116*(T + 273)  
      Mw_mean_t = f/L
      T_t = hA/alfa*(Tdb(time) - T) + lambda*ms/alfa*Mw_mean_t
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION T_0
      if (time.lt.1) then
        T_0 = T0
      else
        T_0 = T
      endif   
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION Mw_right
      if (time.gt.0.0001) then
        Ck = 0.04*exp(1257.14/(T + 273))
        K1 = 0.65*exp(144.57/(T + 273))
        Wm = 0.05*exp(-99.27/(T + 273)) 
        Mw_eq = Ck*K1*Wm*aw/((1 - K1*aw)*(1 - K1*aw + Ck*K1*aw))
        Mw_right = Mw_eq
      else
        Mw_right = Mw0/L
      endif
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION Mw_x_left
      Mw_x_left = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Mw_fit
      Mw_fit = SIMPSN(1,1)*L
C
*     FUNCTION T_fit
      T_fit = T
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
