C
C------------------------------------------------------
C
C     Problem:    MALTDX10
C
C     Date:       16.06.98
C
C------------------------------------------------------
C
*     PARAMETER 
      n = 10
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
C
C------------------------------------------------------
C
*     TABLE L(i), i in ind
      1  0.0020954
      2  0.0020954 
      3  0.0041909
      4  0.0062863 
      5  0.0062863
      6  0.0062863
      7  0.0020954
      8  0.0020954
      9  0.0041909
      10 0.0041909
C
*     TABLE aw(i), i in ind
      1  0.621
      2  0.665
      3  0.556
      4  0.556
      5  0.707
      6  0.619
      7  0.627
      8  0.596
      9  0.4455
      10 0.556
C
*     TABLE ms(i), i in ind
      1  0.00152 
      2  0.00152 
      3  0.00304
      4  0.00304 
      5  0.00456
      6  0.00456
      7  0.00152
      8  0.00152
      9  0.00304
      10 0.00304
C
*     TABLE T0(i), i in ind
      1  42.10848
      2  25.3
      3  24.82989
      4  17.85
      5  25.27742
      6  27.17742
      7  26.60961
      8  22.82607
      9  28.57645
      10 24.3 
C
C------------------------------------------------------
C
*     REAL CONSTANT
      D_scale = 1.0E-8
      P2 = 0
      C1 = 17.44
      Pi = 3.1415926535
      TgMD12 = 164 
      TgH20 = -135
      k = 7.64
      A0 = Pi*0.25*0.0493**2
      Cps = 1500 
      Cpw = 4186.8
C
C------------------------------------------------------
C
*     LININT Tdb1
          0.0   42.10848  
       2900.0   71.68918  
       4500.0   70.06306  
       7000.0   70.69259  
       9500.0   71.13257  
      12800.0   72.35349  
      14000.0   73.45349  
C
*     LININT Tdb2
          0.0   25.3  
       1500.0   66.45  
       7800.0   68.0  
      11500.0   70.45  
      13600.0   71.15  
      16800.0   71.9  
      19300.0   73.6  
C
*     LININT Tdb3
          0.0   24.82989  
       4000.0   70.77262  
       8500.0   71.29033  
      12500.0   71.76174  
      17500.0   70.91927  
      20400.0   71.76174  
      23500.0   71.85603  
C
*     LININT Tdb4
          0.0   17.85  
       1000.0   73.8  
       2000.0   79.89999  
       3000.0   80.2  
       4000.0   81.75  
       5000.0   81.0
       8300.0   80.85  
C
*     LININT Tdb5
          0.0   25.27742  
       4300.0   66.77271  
       9000.0   67.68504        
      12000.0   68.89931  
      15600.0   69.59071  
      19800.0   70.85358  
      22000.0   72.08398  
C
*     LININT Tdb6
          0.0   27.17742  
       2200.0   68.78787  
       9500.0   69.83833  
      14500.0   70.44595  
      22000.0   71.42973  
      24600.0   71.33353  
      27000.0   71.49639  
C
*     LININT Tdb7
          0.0    26.60961  
       2300.0    97.37302  
       4000.0    98.61294  
       6300.0    99.79572  
       9400.0    99.50715  
      11900.0    99.64332  
      13300.0   101.5433  
C
*     LININT Tdb8
          0.0    22.82607  
       1600.0    92.08346  
       6300.0    97.88436  
       9600.0    98.30148  
      12600.0    99.57001  
      14600.0   101.4995  
      18000.0   101.9423
C
*     LININT Tdb9
          0.0   28.57645  
       3000.0   94.28345  
       9000.0   98.28719  
      11200.0   98.53002  
      12000.0   98.53002  
      16500.0   99.55573  
      17000.0   99.4224  
C
*     LININT Tdb10
          0.0      24.3  
       1000.0      87.8  
       2000.0      97.95  
       3000.0     100.75  
       4000.0     102.2  
       5000.0     102.05  
       6000.0     101.85  
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      Dr, P1, Tr, C2
      Mw0(i), i in ind
      Mw(i), i in ind
      Mw_x(i), i in ind
      Mw_xx(i), i in ind
      T(i), i in ind
      f(i), i in ind
      f_x(i), i in ind
      x, time
C
C------------------------------------------------------
C
C   - Flux functions:
C
*     FUNCTION flux(i), i in ind
      Xw = Mw(i)/(1 + Mw(i))
      XMD121 = 1 - Xw
      Tg = (XMD121*TgMD12 + k*Xw*TgH20)/(XMD121 + k*Xw)
      Diff = Dr*D_scale*10**(C1*C2*(T(i)-Tr)
     /     /((C2 + T(i) - Tg)*(C2 - Tg + Tr)))
      flux(i) = Diff*Mw_x(i)/L(i)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION Mw_t(i), i in ind 
      Mw_t(i) = f_x(i)/L(i)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION Mw_0(i), i in ind     
      if (time.lt.1) then
        Mw_0(i) = Mw0(i)/L(i)
      else       
        Mw_0(i) = Mw(i)
      endif  
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
*     FUNCTION T_t(i), i in ind
      Mw_mean = SIMPSN(i,1)
      alfa = ms(i)*Cps + ms(i)*Mw_mean*Cpw
      hA = A0*(P1*Mw_mean + P2)
      lambda = 3114979.2 - 2248.3116*(T(i) + 273)  
      Mw_mean_t = f(i)/L(i)
      if (i.eq.1) then
        Tdb = Tdb1(time)
      else
      if (i.eq.2) then
        Tdb = Tdb2(time)
      else
      if (i.eq.3) then
        Tdb = Tdb3(time)
      else
      if (i.eq.4) then
        Tdb = Tdb4(time)
      else
      if (i.eq.5) then
        Tdb = Tdb5(time)
      else
      if (i.eq.6) then
        Tdb = Tdb6(time)
      else
      if (i.eq.7) then
        Tdb = Tdb7(time)
      else
      if (i.eq.8) then
        Tdb = Tdb8(time)
      else
      if (i.eq.9) then
        Tdb = Tdb9(time)
      else
        Tdb = Tdb10(time)
      endif
      endif
      endif
      endif
      endif
      endif
      endif
      endif
      endif
      T_t(i) = hA/alfa*(Tdb - T(i)) + lambda*ms(i)/alfa*Mw_mean_t
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION T_0(i), i in ind
      if (time.lt.1) then
        T_0(i) = T0(i)
      else
        T_0(i) = T(i)
      endif   
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION Mw_r(i), i in ind
      if (time.gt.0.0001) then
        C1i = 0.04*exp(1257.14/(T(i) + 273))
        K1i = 0.65*exp(144.57/(T(i) + 273))
        Wmi = 0.05*exp(-99.27/(T(i) + 273))
        Mw_eq = C1i*K1i*Wmi*aw(i)/((1 - K1i*aw(i))
     &      *(1 - K1i*aw(i) + C1i*K1i*aw(i)))
        Mw_r(i) = Mw_eq
      else
        Mw_r(i) = Mw0(i)/L(i)
      endif
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION Mw_x_l(i), i in ind
      Mw_x_l(i) = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Mw_fit1
      Mw_fit1 = SIMPSN(1,1)*L(1)
C
*     FUNCTION T_fit1
      T_fit1 = T(1)
C
*     FUNCTION Mw_fit2
      Mw_fit2 = SIMPSN(2,1)*L(2)
C
*     FUNCTION T_fit2
      T_fit2 = T(2)
C
*     FUNCTION Mw_fit3
      Mw_fit3 = SIMPSN(3,1)*L(3)
C
*     FUNCTION T_fit3
      T_fit3 = T(3)
C
*     FUNCTION Mw_fit4
      Mw_fit4 = SIMPSN(4,1)*L(4)
C
*     FUNCTION T_fit4
      T_fit4 = T(4)
C
*     FUNCTION Mw_fit5
      Mw_fit5 = SIMPSN(5,1)*L(5)
C
*     FUNCTION T_fit5
      T_fit5 = T(5)
C
*     FUNCTION Mw_fit6
      Mw_fit6 = SIMPSN(6,1)*L(6)
C
*     FUNCTION T_fit6
      T_fit6 = T(6)
C
*     FUNCTION Mw_fit7
      Mw_fit7 = SIMPSN(7,1)*L(7)
C
*     FUNCTION T_fit7
      T_fit7 = T(7)
C
*     FUNCTION Mw_fit8
      Mw_fit8 = SIMPSN(8,1)*L(8)
C
*     FUNCTION T_fit8
      T_fit8 = T(8)
C
*     FUNCTION Mw_fit9
      Mw_fit9 = SIMPSN(9,1)*L(9)
C
*     FUNCTION T_fit9
      T_fit9 = T(9)
C
*     FUNCTION Mw_fit10
      Mw_fit10 = SIMPSN(10,1)*L(10)
C
*     FUNCTION T_fit10
      T_fit10 = T(10)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
