C
C------------------------------------------------------
C
C     Problem:    LYMPHO
C
C     Date:       29.01.2003
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      beta1 = 1.7
      beta2 = 1
      beta3 = 0.0015
      beta4 = 2.02
      beta5 = 0.005
      beta6 = 0.05
      beta7 = 0.01
      beta8 = 0.005
      beta9 = 0.05
      beta10 = 0.003
      beta11 = 1
      gamma3 = 0.008
      tau2 = 540
      tau3 = 60
      tau4 = 400
      tau5 = 500
      tau6 = 200
      tau7 = 200
      tau8 = 200
      tau9 = 360
      tau10 = 540
      tau11 = 20
C
C------------------------------------------------------
C

C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      alpha1, alpha2, alpha3, alpha4, alpha5, alpha6
      alpha7, alpha8, alpha9, alpha10
      x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t           
      g1 = 1
      x1_t = alpha1*x12 - beta1*g1*x1
C
*     FUNCTION x2_t           
      g2 = 1 - exp(-t/tau2)
      x2_t = alpha2*x12 - beta2*g2*x2
C
*     FUNCTION x3_t           
      g3 = beta3*(1 + gamma3/beta3*(1 - exp(-t/tau3)))
      x3_t = alpha3*x12 - beta3*g3*x3
C
*     FUNCTION x4_t           
      g4 = 1 - exp(-t/tau4)
      x4_t = alpha4*x12 - beta4*g4*x4
C
*     FUNCTION x5_t           
      g5 = 1 - exp(-t/tau5)
      x5_t = alpha5*x12 - beta5*g5*x5
C
*     FUNCTION x6_t           
      g6 = 1 - exp(-t/tau6)
      g7 = 1 - exp(-t/tau7)
      x6_t = alpha6*x12 - beta6*g6*x6 + beta7*g7*x7
C
*     FUNCTION x7_t           
      x7_t = alpha7*x12 - beta7*g7*x7
C
*     FUNCTION x8_t           
      g8 = 1 - exp(-t/tau8)
      g9 = 1 - exp(-t/tau9)
      g10 = 1 - exp(-t/tau10)
      x8_t = alpha8*x12 - beta8*g8*x8 + beta9*g9*x9 + beta10*g10*x10
C
*     FUNCTION x9_t           
      x9_t = alpha9*x12 - beta9*g9*x9
C
*     FUNCTION x10_t           
      x10_t = alpha10*x12 - beta10*g10*x10
C
*     FUNCTION x11_t           
      g11 = 1 - exp(-t/tau11)
      x11_t = beta4*g4*x4 - beta11*g11*x11
C
*     FUNCTION x12_t           
      x12_t = -(x1_t + x2_t + x3_t + x5_t + (alpha4 + alpha6 
     /            + alpha7 + alpha8 + alpha9 + alpha10)*x12 
     /        - beta6*g6*x6 - beta8*g8*x8 - beta11*g11*x11)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 50
C
*     FUNCTION x2_0
      x2_0 = 0
C
*     FUNCTION x3_0
      x3_0 = 0
C
*     FUNCTION x4_0
      x4_0 = 0
C
*     FUNCTION x5_0
      x5_0 = 0
C
*     FUNCTION x6_0
      x6_0 = 0
C
*     FUNCTION x7_0
      x7_0 = 0
C
*     FUNCTION x8_0
      x8_0 = 0
C
*     FUNCTION x9_0
      x9_0 = 0
C
*     FUNCTION x10_0
      x10_0 = 0
C
*     FUNCTION x11_0
      x11_0 = 0
C
*     FUNCTION x12_0
      x12_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
*     FUNCTION x5_fit
      x5_fit = x5
C
*     FUNCTION x6_fit
      x6_fit = x6
C
*     FUNCTION x7_fit
      x7_fit = x7
C
*     FUNCTION x8_fit
      x8_fit = x8
C
*     FUNCTION x9_fit
      x9_fit = x9
C
*     FUNCTION x10_fit
      x10_fit = x10
C
*     FUNCTION x11_fit
      x11_fit = x11
C
*     FUNCTION x12_fit
      x12_fit = x12
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
