C
C------------------------------------------------------
C
C     Problem:    LUNG
C
C     Date:       30.03.1998
C
C------------------------------------------------------
C
*     REAL CONSTANT
      V1=1
      V2=1
      F=1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first space derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second space derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. space variable (x)
C     7. time variable (t)
C
*     VARIABLE
      K, KE, D, P, d0, U, UX, UXX, y1, y2, y3, y4, X, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION UP
      UP = D*UXX
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION U0
      U0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
*     FUNCTION y1P
      y1P = -K*y1-(-F*D*Ux)
C
*     FUNCTION y2P
      y2P = K*y1
C
*     FUNCTION y3P
      y3P = -F*D*Ux-KE*y3
C
*     FUNCTION y4P
      y4P = KE*y3      
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION y10
      y10 = D0
C
*     FUNCTION y20
      y20 = 0
C
*     FUNCTION y30
      y30 = 0
C
*     FUNCTION y40
      y40 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION UL
      UL = y1*P/V1
C
*     FUNCTION UR
      UR = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. space 
C     variable first at left borders of all areas, then 
C     at right borders of all areas:
C
C*     FUNCTION UXL
C      UXL = ...
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT1
      FIT1 = y1
C
*     FUNCTION FIT2
      FIT2 = y2
C
*     FUNCTION FIT3
      FIT3 = y3
C
*     FUNCTION FIT4
      FIT4 = y4
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


