C
C------------------------------------------------------
C
C     Problem:    LORENZ
C
C     Date:       28.04.1993
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      SIGMA, R, B, XS, YS, ZS, X, Y, Z, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XP
      XP = SIGMA*(Y - X)
C
*     FUNCTION YP
      YP = -X*Z + R*X - Y
C
*     FUNCTION ZP
      ZP = X*Y - B*Z
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X0
      X0 = XS
C
*     FUNCTION Y0
      Y0 = YS
C
*     FUNCTION Z0
      Z0 = ZS
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION FIT
      FIT = X
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


