C
C------------------------------------------------------
C
C     Problem:    LOG_GROW
C
C     Date:       21.2.2000
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      h, k, z, a, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION z_t
      z_t = a*z*(1 - z/k) - h
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION z_0
      z_0 = 0.01
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION z_fit
      z_fit = z
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
