C
C------------------------------------------------------
C
C     Problem:    LNCHROM2
C
C     Date:       08.06.2007
C
C------------------------------------------------------
C
*     REAL CONSTANT
      v   = 0.139
      phi = 1.86 
C      
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first space derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second space derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. space variable (x)
C     7. time variable (t)
C
*     VARIABLE
      kdm, kda
      csm, cm, csa, ca
      csm_z, cm_z, csa_z, ca_z
      csm_zz, cm_zz, csa_zz, ca_zz
      z, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION csm_t
      w = z/v
      if (t.gt.w) then   
        csm_t = -(10**kdm)*csm
      else
        csm_t = 0
      endif
C
*     FUNCTION cm_t
      cm_t = -v*cm_z - phi*csm_t  
C
*     FUNCTION csa_t
      w = z/v
      if (t.gt.w) then   
        csa_t = -(10**kda)*csa
      else
        csa_t = 0
      endif
C
*     FUNCTION ca_t
      ca_t = -v*ca_z - phi*csa_t
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION csm_0
      csm_0 = 30.0
C
*     FUNCTION cm_0
      cm_0 = 0.0 
C
*     FUNCTION csa_0
      csa_0 = 5.0
C
*     FUNCTION ca_0
      ca_0 = 0.0      
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
C*     FUNCTION VP
C      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
C*     FUNCTION V0
C      V0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION cml
      cml = 0
C      
*     FUNCTION cal
      cal = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. space 
C     variable first at left borders of all areas, then 
C     at right borders of all areas:
C 
c*     FUNCTION cmr_z
c      cmr_z = ...
C      
c*     FUNCTION car_z
c      car_z = ...        
C
C------------------------------------------------------
C
C   - Fitting criteria:
C                                             
*     FUNCTION fitcm
      fitcm = cm      
C
*     FUNCTION fitca
      fitca = ca    
C                      
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C