C
C------------------------------------------------------
C
C     Problem:    LKIN_T
C
C     Date:       06.03.1994
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1, K2, D, Y1, Y2, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      Y1P=-K1*Y1
C
*     FUNCTION Y2P
      Y2P=K1*Y1 - K2*Y2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      Y10=D
C
*     FUNCTION Y20
      Y20=0.0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION Y1FIT
      Y1FIT=Y1 
C
*     FUNCTION Y2FIT
      Y2FIT=Y2 
C
*     FUNCTION Y3FIT
      if (Y1.gt.0) then
        Y3FIT=(Y1 - D*DEXP(-K1*T))/Y1
      else
        Y3FIT=0
      endif
C
*     FUNCTION Y4FIT
      if (Y2.gt.0) then
        Y4FIT=(Y2 - K1*D/(K1-K2)*(DEXP(-K2*T)
     /         - DEXP(-K1*T)))/Y2
      else
        Y4FIT=0
      endif
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



