C
C------------------------------------------------------
C
C     Problem:    LKIN_S
C
C     Date:       11.05.1997
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1, K2, D, Y1, Y2, D11, D12, D13, D21, D22, D23, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      Y1P=-K1*Y1
C
*     FUNCTION Y2P
      Y2P=K1*Y1 - K2*Y2
C
*     FUNCTION D11P
      D11P = -K1*D11 - Y1
C
*     FUNCTION D12P
      D12P = -K1*D12
C
*     FUNCTION D13P
      D13P = -K1*D13
C
*     FUNCTION D21P
      D21P = K1*D11 - K2*D21 + Y1
C
*     FUNCTION D22P
      D22P = K1*D12 - K2*D22 - Y2
C
*     FUNCTION D23P
      D23P = K1*D13 - K2*D23
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      Y10=D
C
*     FUNCTION Y20
      Y20=0.0
C
*     FUNCTION D110
      D110=0
C
*     FUNCTION D120
      D120=0
C
*     FUNCTION D130
      D130=1
C
*     FUNCTION D210
      D210=0
C
*     FUNCTION D220
      D220=0
C
*     FUNCTION D230
      D230=0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION Y1FIT
      Y1FIT=Y1
c      if (Y1.gt.0) then
c        Y1FIT=(Y1 - D*DEXP(-K1*T))/Y1
c      else
c        Y1FIT=0
c      endif
C
*     FUNCTION Y2FIT
      Y2FIT=Y2
c      if (Y2.gt.0) then
c        Y2FIT=(Y2 - K1*D/(K1-K2)*(DEXP(-K2*T)
c     /         - DEXP(-K1*T)))/Y2
c      else
c        Y2FIT=0
c      endif
C
*     FUNCTION D11FIT
      D11FIT=D11
c      if (D11.gt.0) then
c        D11FIT=(D11 + T*D*dexp(-K1*T))/D11
c      else
c        D11FIT=0
c      endif
C
*     FUNCTION D12FIT
      D12FIT=D12
C
*     FUNCTION D13FIT
      D13FIT=D13
c      if (D13.gt.0) then
c        D13FIT=(D13 - dexp(-K1*T))/D13
c      else
c        D13FIT=0
c      endif
C
*     FUNCTION D21FIT
      D21FIT=D21
c      if (D21.gt.0) then
c        D21FIT=(D21 - K1*D/(K1-K2)*T*dexp(-K1*T)
c     /   + K2*D/(K1-K2)**2*(dexp(-K2*T)-dexp(-K1*T)))/D21
c      else
c        D21FIT=0
c      endif
C
*     FUNCTION D22FIT
      D22FIT=D22
c      if ((D22.gt.0).and.(K1.ne.K2)) then
c        D22FIT=(D22 + K1*D/(K1-K2)*T*dexp(-K2*T)
c     /   - K1*D/(K1-K2)**2*(dexp(-K2*T)-dexp(-K1*T)))/D22
c      else
c        D22FIT=0
c      endif
C
*     FUNCTION D23FIT
      D23FIT=D23
c      if ((D23.gt.0).and.(K1.ne.K2)) then
c        D23FIT=(D23 - K1/(K1-K2)*(dexp(-K2*T)-
c     /            dexp(-K1*T)))/D23
c      else
c        D23FIT=0
c      endif
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C





