C
C------------------------------------------------------
C
C     Problem:    LKIN_NUM
C
C     Date:       06.03.1994
C
C------------------------------------------------------
C
*     REAL CONSTANT
      EPS = 1.0E-6
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1, K2, D
      Y1, Y2, Y1K1, Y2K1, Y1K2, Y2K2, Y1D, Y2D, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      Y1P = -K1*Y1
C
*     FUNCTION Y2P
      Y2P = K1*Y1 - K2*Y2
C
*     FUNCTION Y1K1P
      EPSK1 = EPS*K1
      Y1K1P = -(K1+EPSK1)*Y1K1
C
*     FUNCTION Y2K1P
      Y2K1P = (K1+EPSK1)*Y1K1 - K2*Y2K1
C
*     FUNCTION Y1K2P
      Y1K2P = -K1*Y1K2
C
*     FUNCTION Y2K2P
      EPSK2 = EPS*K2
      Y2K2P = K1*Y1K2 - (K2+EPSK2)*Y2K2
C
*     FUNCTION Y1DP
      Y1DP = -K1*Y1D
C
*     FUNCTION Y2DP
      Y2DP = K1*Y1D - K2*Y2D
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      Y10 = D
C
*     FUNCTION Y20
      Y20 = 0.0
C
*     FUNCTION Y1K10
      Y1K10 = D
C
*     FUNCTION Y2K10
      Y2K10 = 0.0
C
*     FUNCTION Y1K20
      Y1K20 = D
C
*     FUNCTION Y2K20
      Y2K20 = 0.0
C
*     FUNCTION Y1D0
      EPSD = EPS*D
      Y1D0 = D + EPSD
C
*     FUNCTION Y2D0
      Y2D0 = 0.0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION Y1FIT
      Y1FIT = Y1
C
*     FUNCTION Y2FIT
      Y2FIT = Y2
C
*     FUNCTION D11FIT
      EPSK1 = EPS*K1
      D11 = (Y1K1 - Y1)/EPSK1
      if (D11.gt.0) then
        D11FIT = (D11 + T*D*dexp(-K1*T))/D11
      else
        D11FIT = 0
      endif
C
*     FUNCTION D12FIT
      EPSK2 = EPS*K2
      D12 = (Y1K2 - Y1)/EPSK2
      D12FIT = D12
C
*     FUNCTION D13FIT
      EPSD = EPS*D
      D13 = (Y1D - Y1)/EPSD
      if (D13.gt.0) then
        D13FIT = (D13 - dexp(-K1*T))/D13
      else
        D13FIT = 0
      endif
C
*     FUNCTION D21FIT
      D21 = (Y2K1 - Y2)/EPSK1
      if (D21.gt.0) then
        D21FIT = (D21 - K1*D/(K1-K2)*T*dexp(-K1*T)
     /   + K2*D/(K1-K2)**2*(dexp(-K2*T)-dexp(-K1*T)))/D21
      else
        D21FIT = 0
      endif
C
*     FUNCTION D22FIT
      D22 = (Y2K2 - Y2)/EPSK2
      if ((D22.gt.0).and.(K1.ne.K2)) then
        D22FIT = (D22 + K1*D/(K1-K2)*T*dexp(-K2*T)
     /   - K1*D/(K1-K2)**2*(dexp(-K2*T)-dexp(-K1*T)))/D22
      else
        D22FIT = 0
      endif
C
*     FUNCTION D23FIT
      D23 = (Y2D - Y2)/EPSD
      if ((D23.gt.0).and.(K1.ne.K2)) then
        D23FIT = (D23 - K1/(K1-K2)*(dexp(-K2*T)-
     /            dexp(-K1*T)))/D23
      else
        D23FIT = 0
      endif
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

