C
C------------------------------------------------------
C
C     Problem:    LKIN_BR
C
C     Date:       22.12.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      D0 = 100
      D1 = 40
      D2 = 40  
      tau1 = 24
      tau2 = 48
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, y1, y2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = -k1*y1
C
*     FUNCTION y2_t
      y2_t = k1*y1 - k2*y2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      IF (t.LT.1) THEN
        y1_0 = D0
      ELSE
      IF (t.LT.tau1+1) THEN
        y1_0 = y1 + D1
      ELSE
        y1_0 = y1 + D2
      ENDIF
      ENDIF
C
*     FUNCTION y2_0
      IF (t.LT.1) THEN  
        y2_0 = 0
      ELSE
        y2_0 = y2
      ENDIF

C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


